/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutorMBean;
import org.apache.cassandra.concurrent.NamedThreadFactory;

public class JMXEnabledThreadPoolExecutor
extends DebuggableThreadPoolExecutor
implements JMXEnabledThreadPoolExecutorMBean {
    private final String mbeanName;

    public JMXEnabledThreadPoolExecutor(String threadPoolName) {
        this(1, 1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName));
    }

    public JMXEnabledThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamedThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        super.prestartAllCoreThreads();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        this.mbeanName = "org.apache.cassandra.concurrent:type=" + threadFactory.id;
        try {
            mbs.registerMBean(this, new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void unregisterMBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    @Override
    public long getCompletedTasks() {
        return this.getCompletedTaskCount();
    }

    @Override
    public long getPendingTasks() {
        return this.getTaskCount() - this.getCompletedTaskCount();
    }
}

