/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;

public class StageManager {
    private static Map<String, ThreadPoolExecutor> stages = new HashMap<String, ThreadPoolExecutor>();
    public static final String READ_STAGE = "ROW-READ-STAGE";
    public static final String MUTATION_STAGE = "ROW-MUTATION-STAGE";
    public static final String STREAM_STAGE = "STREAM-STAGE";
    public static final String GOSSIP_STAGE = "GS";
    public static final String RESPONSE_STAGE = "RESPONSE-STAGE";
    public static final String AE_SERVICE_STAGE = "AE-SERVICE-STAGE";
    private static final String LOADBALANCE_STAGE = "LOAD-BALANCER-STAGE";

    private static ThreadPoolExecutor multiThreadedStage(String name, int numThreads) {
        assert (numThreads > 1) : "multi-threaded stages must have at least 2 threads";
        return new JMXEnabledThreadPoolExecutor(numThreads, numThreads, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(DatabaseDescriptor.getStageQueueSize()), new NamedThreadFactory(name));
    }

    public static ThreadPoolExecutor getStage(String stageName) {
        return stages.get(stageName);
    }

    public static void shutdownNow() {
        Set<String> stages = StageManager.stages.keySet();
        for (String stage : stages) {
            StageManager.stages.get(stage).shutdownNow();
        }
    }

    static {
        stages.put(MUTATION_STAGE, StageManager.multiThreadedStage(MUTATION_STAGE, DatabaseDescriptor.getConcurrentWriters()));
        stages.put(READ_STAGE, StageManager.multiThreadedStage(READ_STAGE, DatabaseDescriptor.getConcurrentReaders()));
        stages.put(RESPONSE_STAGE, StageManager.multiThreadedStage(RESPONSE_STAGE, Math.max(2, Runtime.getRuntime().availableProcessors())));
        stages.put(STREAM_STAGE, new JMXEnabledThreadPoolExecutor(STREAM_STAGE));
        stages.put(GOSSIP_STAGE, new JMXEnabledThreadPoolExecutor("GMFD"));
        stages.put(AE_SERVICE_STAGE, new JMXEnabledThreadPoolExecutor(AE_SERVICE_STAGE));
        stages.put(LOADBALANCE_STAGE, new JMXEnabledThreadPoolExecutor(LOADBALANCE_STAGE));
    }
}

