/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.FBUtilities;

public final class CFMetaData {
    public static final double DEFAULT_KEY_CACHE_SIZE = 200000.0;
    public static final double DEFAULT_ROW_CACHE_SIZE = 0.0;
    public final String tableName;
    public final String cfName;
    public final String columnType;
    public final AbstractType comparator;
    public final AbstractType subcolumnComparator;
    public final String comment;
    public final double rowCacheSize;
    public final double keyCacheSize;

    CFMetaData(String tableName, String cfName, String columnType, AbstractType comparator, AbstractType subcolumnComparator, String comment, double rowCacheSize, double keyCacheSize) {
        this.tableName = tableName;
        this.cfName = cfName;
        this.columnType = columnType;
        this.comparator = comparator;
        this.subcolumnComparator = subcolumnComparator;
        this.comment = comment;
        this.rowCacheSize = rowCacheSize;
        this.keyCacheSize = keyCacheSize;
    }

    public String pretty() {
        return this.tableName + "." + this.cfName + "\n" + "Column Family Type: " + this.columnType + "\n" + "Columns Sorted By: " + this.comparator + "\n";
    }

    public static byte[] serialize(CFMetaData cfm) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(cfm.tableName);
        dout.writeUTF(cfm.cfName);
        dout.writeUTF(cfm.columnType);
        dout.writeUTF(cfm.comparator.getClass().getName());
        dout.writeBoolean(cfm.subcolumnComparator != null);
        if (cfm.subcolumnComparator != null) {
            dout.writeUTF(cfm.subcolumnComparator.getClass().getName());
        }
        dout.writeBoolean(cfm.comment != null);
        if (cfm.comment != null) {
            dout.writeUTF(cfm.comment);
        }
        dout.writeDouble(cfm.rowCacheSize);
        dout.writeDouble(cfm.keyCacheSize);
        dout.close();
        return bout.toByteArray();
    }

    public static CFMetaData deserialize(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        String tableName = din.readUTF();
        String cfName = din.readUTF();
        String columnType = din.readUTF();
        AbstractType comparator = null;
        try {
            comparator = (AbstractType)Class.forName(din.readUTF()).newInstance();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        AbstractType subcolumnComparator = null;
        try {
            subcolumnComparator = din.readBoolean() ? (AbstractType)Class.forName(din.readUTF()).newInstance() : null;
        }
        catch (Exception ex) {
            // empty catch block
        }
        String comment = din.readBoolean() ? din.readUTF() : null;
        double rowCacheSize = din.readDouble();
        double keyCacheSize = din.readDouble();
        return new CFMetaData(tableName, cfName, columnType, comparator, subcolumnComparator, comment, rowCacheSize, keyCacheSize);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CFMetaData)) {
            return false;
        }
        CFMetaData other = (CFMetaData)obj;
        return other.tableName.equals(this.tableName) && other.cfName.equals(this.cfName) && other.columnType.equals(this.columnType) && other.comparator.equals(this.comparator) && FBUtilities.equals(other.subcolumnComparator, this.subcolumnComparator) && FBUtilities.equals(other.comment, this.comment) && other.rowCacheSize == this.rowCacheSize && other.keyCacheSize == this.keyCacheSize;
    }
}

