/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DatabaseDescriptor {
    private static Logger logger = Logger.getLogger(DatabaseDescriptor.class);
    public static final String STREAMING_SUBDIR = "stream";
    public static final String random = "RANDOM";
    public static final String ophf = "OPHF";
    private static int storagePort = 7000;
    private static int thriftPort = 9160;
    private static boolean thriftFramed = false;
    private static InetAddress listenAddress;
    private static InetAddress thriftAddress;
    private static String clusterName;
    private static long rpcTimeoutInMillis;
    private static Set<InetAddress> seeds;
    private static String[] dataFileDirectories;
    private static int currentIndex;
    private static String logFileDirectory;
    private static int consistencyThreads;
    private static int concurrentReaders;
    private static int concurrentWriters;
    private static double flushDataBufferSizeInMB;
    private static double flushIndexBufferSizeInMB;
    private static int slicedReadBufferSizeInKB;
    static Map<String, KSMetaData> tables;
    private static int bmtThreshold;
    private static long rowWarningThreshold;
    private static IPartitioner partitioner;
    private static int columnIndexSizeInKB;
    private static int memtableLifetimeMs;
    private static int memtableThroughput;
    private static double memtableOperations;
    private static boolean doConsistencyCheck;
    private static String jobJarFileLocation;
    private static String jobTrackerHost;
    private static int gcGraceInSeconds;
    private static String configFileName;
    private static String initialToken;
    private static CommitLogSync commitLogSync;
    private static double commitLogSyncBatchMS;
    private static int commitLogSyncPeriodMS;
    private static DiskAccessMode diskAccessMode;
    private static DiskAccessMode indexAccessMode;
    private static boolean snapshotBeforeCompaction;
    private static boolean autoBootstrap;
    private static IAuthenticator authenticator;
    private static final String STORAGE_CONF_FILE = "storage-conf.xml";
    private static int stageQueueSize_;

    static String getStorageConfigPath() {
        String scp = System.getProperty("storage-config") + File.separator + STORAGE_CONF_FILE;
        if (new File(scp).exists()) {
            return scp;
        }
        ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
        URL scpurl = loader.getResource(STORAGE_CONF_FILE);
        if (scpurl != null) {
            return scpurl.getFile();
        }
        throw new RuntimeException("Cannot locate storage-conf.xml via storage-config system property or classpath lookup.");
    }

    private static void readTablesFromXml() throws ConfigurationException {
        XMLUtils xmlUtils = null;
        try {
            xmlUtils = new XMLUtils(configFileName);
        }
        catch (ParserConfigurationException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (SAXException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        try {
            NodeList tablesxml = xmlUtils.getRequestedNodeList("/Storage/Keyspaces/Keyspace");
            int size = tablesxml.getLength();
            for (int i = 0; i < size; ++i) {
                String value = null;
                Node table = tablesxml.item(i);
                String ksName = XMLUtils.getAttributeValue(table, "Name");
                if (ksName == null) {
                    throw new ConfigurationException("Table name attribute is required");
                }
                if (ksName.equalsIgnoreCase("system")) {
                    throw new ConfigurationException("'system' is a reserved table name for Cassandra internals");
                }
                String replicaPlacementStrategyClassName = xmlUtils.getNodeValue("/Storage/Keyspaces/Keyspace[@Name='" + ksName + "']/ReplicaPlacementStrategy");
                if (replicaPlacementStrategyClassName == null) {
                    throw new ConfigurationException("Missing replicaplacementstrategy directive for " + ksName);
                }
                Class<?> repStratClass = null;
                try {
                    repStratClass = Class.forName(replicaPlacementStrategyClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Invalid replicaplacementstrategy class " + replicaPlacementStrategyClassName);
                }
                String replicationFactor = xmlUtils.getNodeValue("/Storage/Keyspaces/Keyspace[@Name='" + ksName + "']/ReplicationFactor");
                int repFact = -1;
                if (replicationFactor == null) {
                    throw new ConfigurationException("Missing replicationfactor directory for keyspace " + ksName);
                }
                repFact = Integer.parseInt(replicationFactor);
                String endPointSnitchClassName = xmlUtils.getNodeValue("/Storage/Keyspaces/Keyspace[@Name='" + ksName + "']/EndPointSnitch");
                if (endPointSnitchClassName == null) {
                    throw new ConfigurationException("Missing endpointsnitch directive for keyspace " + ksName);
                }
                IEndPointSnitch epSnitch = null;
                try {
                    Class<?> cls = Class.forName(endPointSnitchClassName);
                    epSnitch = (IEndPointSnitch)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Invalid endpointsnitch class " + endPointSnitchClassName);
                }
                catch (NoSuchMethodException e) {
                    throw new ConfigurationException("Invalid endpointsnitch class " + endPointSnitchClassName + " " + e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new ConfigurationException("Invalid endpointsnitch class " + endPointSnitchClassName + " " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("Invalid endpointsnitch class " + endPointSnitchClassName + " " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationException("Invalid endpointsnitch class " + endPointSnitchClassName + " " + e.getMessage());
                }
                String xqlTable = "/Storage/Keyspaces/Keyspace[@Name='" + ksName + "']/";
                NodeList columnFamilies = xmlUtils.getRequestedNodeList(xqlTable + "ColumnFamily");
                KSMetaData meta = new KSMetaData(ksName, repStratClass, repFact, epSnitch);
                int size2 = columnFamilies.getLength();
                for (int j = 0; j < size2; ++j) {
                    Node columnFamily = columnFamilies.item(j);
                    String tableName = ksName;
                    String cfName = XMLUtils.getAttributeValue(columnFamily, "Name");
                    if (cfName == null) {
                        throw new ConfigurationException("ColumnFamily name attribute is required");
                    }
                    if (cfName.contains("-")) {
                        throw new ConfigurationException("ColumnFamily names cannot contain hyphens");
                    }
                    String xqlCF = xqlTable + "ColumnFamily[@Name='" + cfName + "']/";
                    String rawColumnType = XMLUtils.getAttributeValue(columnFamily, "ColumnType");
                    String columnType = ColumnFamily.getColumnType(rawColumnType);
                    if (columnType == null) {
                        throw new ConfigurationException("ColumnFamily " + cfName + " has invalid type " + rawColumnType);
                    }
                    if (XMLUtils.getAttributeValue(columnFamily, "ColumnSort") != null) {
                        throw new ConfigurationException("ColumnSort is no longer an accepted attribute.  Use CompareWith instead.");
                    }
                    AbstractType comparator = DatabaseDescriptor.getComparator(columnFamily, "CompareWith");
                    AbstractType subcolumnComparator = null;
                    if (columnType.equals("Super")) {
                        subcolumnComparator = DatabaseDescriptor.getComparator(columnFamily, "CompareSubcolumnsWith");
                    } else if (XMLUtils.getAttributeValue(columnFamily, "CompareSubcolumnsWith") != null) {
                        throw new ConfigurationException("CompareSubcolumnsWith is only a valid attribute on super columnfamilies (not regular columnfamily " + cfName + ")");
                    }
                    double keyCacheSize = 200000.0;
                    value = XMLUtils.getAttributeValue(columnFamily, "KeysCachedFraction");
                    if (value != null) {
                        keyCacheSize = Double.valueOf(value);
                        logger.warn((Object)"KeysCachedFraction is deprecated: use KeysCached instead.");
                    }
                    if ((value = XMLUtils.getAttributeValue(columnFamily, "KeysCached")) != null) {
                        keyCacheSize = FBUtilities.parseDoubleOrPercent(value);
                    }
                    double rowCacheSize = 0.0;
                    value = XMLUtils.getAttributeValue(columnFamily, "RowsCached");
                    if (value != null) {
                        rowCacheSize = FBUtilities.parseDoubleOrPercent(value);
                    }
                    String comment = xmlUtils.getNodeValue(xqlCF + "Comment");
                    meta.cfMetaData.put(cfName, new CFMetaData(tableName, cfName, columnType, comparator, subcolumnComparator, comment, rowCacheSize, keyCacheSize));
                }
                tables.put(meta.name, meta);
            }
        }
        catch (XPathExpressionException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (TransformerException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public static IAuthenticator getAuthenticator() {
        return authenticator;
    }

    public static boolean isThriftFramed() {
        return thriftFramed;
    }

    private static AbstractType getComparator(Node columnFamily, String attr) throws ConfigurationException {
        Class typeClass;
        String compareWith = null;
        try {
            compareWith = XMLUtils.getAttributeValue(columnFamily, attr);
        }
        catch (TransformerException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        if (compareWith == null) {
            typeClass = BytesType.class;
        } else {
            String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
            try {
                typeClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Unable to load class " + className + " for " + attr + " attribute");
            }
        }
        try {
            return (AbstractType)typeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (NoSuchMethodException e) {
            ConfigurationException ex = new ConfigurationException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public static void createAllDirectories() throws IOException {
        try {
            if (dataFileDirectories.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified");
            }
            for (String dataFileDirectory : dataFileDirectories) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            if (logFileDirectory == null) {
                throw new ConfigurationException("CommitLogDirectory must be specified");
            }
            FileUtils.createDirectory(logFileDirectory);
        }
        catch (ConfigurationException ex) {
            logger.error((Object)("Fatal error: " + ex.getMessage()));
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
        for (String dataFile : dataFileDirectories) {
            FileUtils.createDirectory(dataFile + File.separator + "system");
            for (String table : tables.keySet()) {
                String oneDir = dataFile + File.separator + table;
                FileUtils.createDirectory(oneDir);
                File streamingDir = new File(oneDir, STREAMING_SUBDIR);
                if (!streamingDir.exists()) continue;
                FileUtils.deleteDir(streamingDir);
            }
        }
    }

    public static void storeMetadata() throws IOException {
        int cfId = 0;
        Set<String> tableset = tables.keySet();
        for (String table : tableset) {
            Table.TableMetadata tmetadata = Table.TableMetadata.instance(table);
            if (!tmetadata.isEmpty()) continue;
            tmetadata = Table.TableMetadata.instance(table);
            Map<String, CFMetaData> columnFamilies = DatabaseDescriptor.tables.get((Object)table).cfMetaData;
            for (String columnFamily : columnFamilies.keySet()) {
                tmetadata.add(columnFamily, cfId++, DatabaseDescriptor.getColumnType(table, columnFamily));
            }
        }
    }

    public static int getGcGraceInSeconds() {
        return gcGraceInSeconds;
    }

    public static IPartitioner getPartitioner() {
        return partitioner;
    }

    public static IEndPointSnitch getEndPointSnitch(String table) {
        return DatabaseDescriptor.tables.get((Object)table).epSnitch;
    }

    public static Class<? extends AbstractReplicationStrategy> getReplicaPlacementStrategyClass(String table) {
        return DatabaseDescriptor.tables.get((Object)table).repStratClass;
    }

    public static String getJobTrackerAddress() {
        return jobTrackerHost;
    }

    public static int getColumnIndexSize() {
        return columnIndexSizeInKB * 1024;
    }

    public static int getMemtableLifetimeMS() {
        return memtableLifetimeMs;
    }

    public static String getInitialToken() {
        return initialToken;
    }

    public static int getMemtableThroughput() {
        return memtableThroughput;
    }

    public static double getMemtableOperations() {
        return memtableOperations;
    }

    public static boolean getConsistencyCheck() {
        return doConsistencyCheck;
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public static String getJobJarLocation() {
        return jobJarFileLocation;
    }

    public static Map<String, CFMetaData> getTableMetaData(String tableName) {
        assert (tableName != null);
        KSMetaData ksm = tables.get(tableName);
        assert (ksm != null);
        return Collections.unmodifiableMap(ksm.cfMetaData);
    }

    public static CFMetaData getCFMetaData(String tableName, String cfName) {
        assert (tableName != null);
        KSMetaData ksm = tables.get(tableName);
        if (ksm == null) {
            return null;
        }
        return ksm.cfMetaData.get(cfName);
    }

    public static String getColumnType(String tableName, String cfName) {
        assert (tableName != null);
        CFMetaData cfMetaData = DatabaseDescriptor.getCFMetaData(tableName, cfName);
        if (cfMetaData == null) {
            return null;
        }
        return cfMetaData.columnType;
    }

    public static Set<String> getTables() {
        return tables.keySet();
    }

    public static List<String> getNonSystemTables() {
        ArrayList<String> tableslist = new ArrayList<String>(tables.keySet());
        tableslist.remove("system");
        return Collections.unmodifiableList(tableslist);
    }

    public static int getStoragePort() {
        return storagePort;
    }

    public static int getThriftPort() {
        return thriftPort;
    }

    public static int getReplicationFactor(String table) {
        return DatabaseDescriptor.tables.get((Object)table).replicationFactor;
    }

    public static int getQuorum(String table) {
        return DatabaseDescriptor.tables.get((Object)table).replicationFactor / 2 + 1;
    }

    public static long getRpcTimeout() {
        return rpcTimeoutInMillis;
    }

    public static int getConsistencyThreads() {
        return consistencyThreads;
    }

    public static int getConcurrentReaders() {
        return concurrentReaders;
    }

    public static int getConcurrentWriters() {
        return concurrentWriters;
    }

    public static long getRowWarningThreshold() {
        return rowWarningThreshold;
    }

    public static String[] getAllDataFileLocations() {
        return dataFileDirectories;
    }

    public static String[] getAllDataFileLocationsForTable(String table) {
        String[] tableLocations = new String[dataFileDirectories.length];
        for (int i = 0; i < dataFileDirectories.length; ++i) {
            tableLocations[i] = dataFileDirectories[i] + File.separator + table;
        }
        return tableLocations;
    }

    public static synchronized String getNextAvailableDataLocation() {
        String dataFileDirectory = dataFileDirectories[currentIndex];
        currentIndex = (currentIndex + 1) % dataFileDirectories.length;
        return dataFileDirectory;
    }

    public static String getLogFileLocation() {
        return logFileDirectory;
    }

    public static Set<InetAddress> getSeeds() {
        return seeds;
    }

    public static String getColumnFamilyType(String tableName, String cfName) {
        assert (tableName != null);
        String cfType = DatabaseDescriptor.getColumnType(tableName, cfName);
        if (cfType == null) {
            cfType = "Standard";
        }
        return cfType;
    }

    public static String getDataFileLocationForTable(String table, long expectedCompactedFileSize) {
        long maxFreeDisk = 0L;
        int maxDiskIndex = 0;
        String dataFileDirectory = null;
        String[] dataDirectoryForTable = DatabaseDescriptor.getAllDataFileLocationsForTable(table);
        for (int i = 0; i < dataDirectoryForTable.length; ++i) {
            File f = new File(dataDirectoryForTable[i]);
            if (maxFreeDisk >= f.getUsableSpace()) continue;
            maxFreeDisk = f.getUsableSpace();
            maxDiskIndex = i;
        }
        if (expectedCompactedFileSize < (maxFreeDisk = (long)(0.9 * (double)maxFreeDisk))) {
            dataFileDirectory = dataDirectoryForTable[maxDiskIndex];
            currentIndex = (maxDiskIndex + 1) % dataDirectoryForTable.length;
        } else {
            currentIndex = maxDiskIndex;
        }
        return dataFileDirectory;
    }

    public static AbstractType getComparator(String tableName, String cfName) {
        assert (tableName != null);
        CFMetaData cfmd = DatabaseDescriptor.getCFMetaData(tableName, cfName);
        if (cfmd == null) {
            throw new NullPointerException("Unknown ColumnFamily " + cfName + " in keyspace " + tableName);
        }
        return cfmd.comparator;
    }

    public static AbstractType getSubComparator(String tableName, String cfName) {
        assert (tableName != null);
        return DatabaseDescriptor.getCFMetaData((String)tableName, (String)cfName).subcolumnComparator;
    }

    public static int getStageQueueSize() {
        return stageQueueSize_;
    }

    public static int getKeysCachedFor(String tableName, String columnFamilyName, long expectedKeys) {
        CFMetaData cfm = DatabaseDescriptor.getCFMetaData(tableName, columnFamilyName);
        double v = cfm == null ? 200000.0 : cfm.keyCacheSize;
        return (int)Math.min(FBUtilities.absoluteFromFraction(v, expectedKeys), Integer.MAX_VALUE);
    }

    public static int getRowsCachedFor(String tableName, String columnFamilyName, long expectedRows) {
        CFMetaData cfm = DatabaseDescriptor.getCFMetaData(tableName, columnFamilyName);
        double v = cfm == null ? 0.0 : cfm.rowCacheSize;
        return (int)Math.min(FBUtilities.absoluteFromFraction(v, expectedRows), Integer.MAX_VALUE);
    }

    public static InetAddress getListenAddress() {
        return listenAddress;
    }

    public static InetAddress getThriftAddress() {
        return thriftAddress;
    }

    public static double getCommitLogSyncBatchWindow() {
        return commitLogSyncBatchMS;
    }

    public static int getCommitLogSyncPeriod() {
        return commitLogSyncPeriodMS;
    }

    public static CommitLogSync getCommitLogSync() {
        return commitLogSync;
    }

    public static DiskAccessMode getDiskAccessMode() {
        return diskAccessMode;
    }

    public static DiskAccessMode getIndexAccessMode() {
        return indexAccessMode;
    }

    public static double getFlushDataBufferSizeInMB() {
        return flushDataBufferSizeInMB;
    }

    public static double getFlushIndexBufferSizeInMB() {
        return flushIndexBufferSizeInMB;
    }

    public static int getIndexedReadBufferSizeInKB() {
        return columnIndexSizeInKB;
    }

    public static int getSlicedReadBufferSizeInKB() {
        return slicedReadBufferSizeInKB;
    }

    public static int getBMTThreshold() {
        return bmtThreshold;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return snapshotBeforeCompaction;
    }

    public static boolean isAutoBootstrap() {
        return autoBootstrap;
    }

    static {
        clusterName = "Test";
        rpcTimeoutInMillis = 2000L;
        seeds = new HashSet<InetAddress>();
        currentIndex = 0;
        consistencyThreads = 4;
        concurrentReaders = 8;
        concurrentWriters = 32;
        flushDataBufferSizeInMB = 32.0;
        flushIndexBufferSizeInMB = 8.0;
        slicedReadBufferSizeInKB = 64;
        tables = new HashMap<String, KSMetaData>();
        bmtThreshold = 256;
        rowWarningThreshold = 0x20000000L;
        memtableLifetimeMs = 3600000;
        memtableThroughput = 64;
        memtableOperations = 0.1;
        doConsistencyCheck = true;
        gcGraceInSeconds = 864000;
        initialToken = null;
        autoBootstrap = false;
        authenticator = new AllowAllAuthenticator();
        stageQueueSize_ = 4096;
        try {
            String columnIndexSize;
            String memtableObjectCount;
            String memtableSize;
            String lifetime;
            String autoBootstr;
            String sbc;
            String framedRaw;
            String thriftAddr;
            String listenAddr;
            String port;
            String bmtThresh;
            String rawSlicedBuffer;
            String rawFlushIndex;
            String rawReaders;
            String partitionerClassName;
            configFileName = DatabaseDescriptor.getStorageConfigPath();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading settings from " + configFileName));
            }
            XMLUtils xmlUtils = new XMLUtils(configFileName);
            clusterName = xmlUtils.getNodeValue("/Storage/ClusterName");
            String syncRaw = xmlUtils.getNodeValue("/Storage/CommitLogSync");
            try {
                commitLogSync = CommitLogSync.valueOf(syncRaw);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("CommitLogSync must be either 'periodic' or 'batch'");
            }
            if (commitLogSync == null) {
                throw new ConfigurationException("Missing required directive CommitLogSync");
            }
            if (commitLogSync == CommitLogSync.batch) {
                try {
                    commitLogSyncBatchMS = Double.valueOf(xmlUtils.getNodeValue("/Storage/CommitLogSyncBatchWindowInMS"));
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unrecognized value for CommitLogSyncBatchWindowInMS.  Double expected.");
                }
                if (xmlUtils.getNodeValue("/Storage/CommitLogSyncPeriodInMS") != null) {
                    throw new ConfigurationException("Batch sync specified, but CommitLogSyncPeriodInMS found.  Only specify CommitLogSyncBatchWindowInMS when using batch sync.");
                }
                logger.debug((Object)("Syncing log with a batch window of " + commitLogSyncBatchMS));
            } else {
                assert (commitLogSync == CommitLogSync.periodic);
                try {
                    commitLogSyncPeriodMS = Integer.valueOf(xmlUtils.getNodeValue("/Storage/CommitLogSyncPeriodInMS"));
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unrecognized value for CommitLogSyncPeriodInMS.  Integer expected.");
                }
                if (xmlUtils.getNodeValue("/Storage/CommitLogSyncBatchWindowInMS") != null) {
                    throw new ConfigurationException("Periodic sync specified, but CommitLogSyncBatchWindowInMS found.  Only specify CommitLogSyncPeriodInMS when using periodic sync.");
                }
                logger.debug((Object)("Syncing log with a period of " + commitLogSyncPeriodMS));
            }
            String modeRaw = xmlUtils.getNodeValue("/Storage/DiskAccessMode");
            try {
                diskAccessMode = DiskAccessMode.valueOf(modeRaw);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("DiskAccessMode must be either 'auto', 'mmap', 'mmap_index_only', or 'standard'");
            }
            if (diskAccessMode == DiskAccessMode.auto) {
                indexAccessMode = diskAccessMode = System.getProperty("os.arch").contains("64") ? DiskAccessMode.mmap : DiskAccessMode.standard;
                logger.info((Object)("Auto DiskAccessMode determined to be " + (Object)((Object)diskAccessMode)));
            } else if (diskAccessMode == DiskAccessMode.mmap_index_only) {
                diskAccessMode = DiskAccessMode.standard;
                indexAccessMode = DiskAccessMode.mmap;
            } else {
                indexAccessMode = diskAccessMode;
            }
            String authenticatorClassName = xmlUtils.getNodeValue("/Storage/Authenticator");
            if (authenticatorClassName != null) {
                try {
                    Class<?> cls = Class.forName(authenticatorClassName);
                    authenticator = (IAuthenticator)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Invalid authenticator class " + authenticatorClassName);
                }
            }
            if ((partitionerClassName = xmlUtils.getNodeValue("/Storage/Partitioner")) == null) {
                throw new ConfigurationException("Missing partitioner directive /Storage/Partitioner");
            }
            try {
                Class<?> cls = Class.forName(partitionerClassName);
                partitioner = (IPartitioner)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Invalid partitioner class " + partitionerClassName);
            }
            jobTrackerHost = xmlUtils.getNodeValue("/Storage/JobTrackerHost");
            jobJarFileLocation = xmlUtils.getNodeValue("/Storage/JobJarFileLocation");
            String gcGrace = xmlUtils.getNodeValue("/Storage/GCGraceSeconds");
            if (gcGrace != null) {
                gcGraceInSeconds = Integer.parseInt(gcGrace);
            }
            initialToken = xmlUtils.getNodeValue("/Storage/InitialToken");
            String rpcTimeout = xmlUtils.getNodeValue("/Storage/RpcTimeoutInMillis");
            if (rpcTimeout != null) {
                rpcTimeoutInMillis = Integer.parseInt(rpcTimeout);
            }
            if ((rawReaders = xmlUtils.getNodeValue("/Storage/ConcurrentReads")) != null) {
                concurrentReaders = Integer.parseInt(rawReaders);
            }
            if (concurrentReaders < 2) {
                throw new ConfigurationException("ConcurrentReads must be at least 2");
            }
            String rawWriters = xmlUtils.getNodeValue("/Storage/ConcurrentWrites");
            if (rawWriters != null) {
                concurrentWriters = Integer.parseInt(rawWriters);
            }
            if (concurrentWriters < 2) {
                throw new ConfigurationException("ConcurrentWrites must be at least 2");
            }
            String rawFlushData = xmlUtils.getNodeValue("/Storage/FlushDataBufferSizeInMB");
            if (rawFlushData != null) {
                flushDataBufferSizeInMB = Double.parseDouble(rawFlushData);
            }
            if ((rawFlushIndex = xmlUtils.getNodeValue("/Storage/FlushIndexBufferSizeInMB")) != null) {
                flushIndexBufferSizeInMB = Double.parseDouble(rawFlushIndex);
            }
            if ((rawSlicedBuffer = xmlUtils.getNodeValue("/Storage/SlicedBufferSizeInKB")) != null) {
                slicedReadBufferSizeInKB = Integer.parseInt(rawSlicedBuffer);
            }
            if ((bmtThresh = xmlUtils.getNodeValue("/Storage/BinaryMemtableThroughputInMB")) != null) {
                bmtThreshold = Integer.parseInt(bmtThresh);
            }
            if ((port = xmlUtils.getNodeValue("/Storage/StoragePort")) != null) {
                storagePort = Integer.parseInt(port);
            }
            if ((listenAddr = xmlUtils.getNodeValue("/Storage/ListenAddress")) != null) {
                if (listenAddr.equals("0.0.0.0")) {
                    throw new ConfigurationException("ListenAddress must be a single interface.  See http://wiki.apache.org/cassandra/FAQ#cant_listen_on_ip_any");
                }
                try {
                    listenAddress = InetAddress.getByName(listenAddr);
                }
                catch (UnknownHostException e) {
                    throw new ConfigurationException("Unknown ListenAddress '" + listenAddr + "'");
                }
            }
            if ((thriftAddr = xmlUtils.getNodeValue("/Storage/ThriftAddress")) != null) {
                thriftAddress = InetAddress.getByName(thriftAddr);
            }
            if ((port = xmlUtils.getNodeValue("/Storage/ThriftPort")) != null) {
                thriftPort = Integer.parseInt(port);
            }
            if ((framedRaw = xmlUtils.getNodeValue("/Storage/ThriftFramedTransport")) != null) {
                if (framedRaw.equalsIgnoreCase("true") || framedRaw.equalsIgnoreCase("false")) {
                    thriftFramed = Boolean.valueOf(framedRaw);
                } else {
                    throw new ConfigurationException("Unrecognized value for ThriftFramedTransport.  Use 'true' or 'false'.");
                }
            }
            if ((sbc = xmlUtils.getNodeValue("/Storage/SnapshotBeforeCompaction")) != null) {
                if (sbc.equalsIgnoreCase("true") || sbc.equalsIgnoreCase("false")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("setting snapshotBeforeCompaction to " + sbc));
                    }
                    snapshotBeforeCompaction = Boolean.valueOf(sbc);
                } else {
                    throw new ConfigurationException("Unrecognized value for SnapshotBeforeCompaction.  Use 'true' or 'false'.");
                }
            }
            if ((autoBootstr = xmlUtils.getNodeValue("/Storage/AutoBootstrap")) != null) {
                if (autoBootstr.equalsIgnoreCase("true") || autoBootstr.equalsIgnoreCase("false")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("setting autoBootstrap to " + autoBootstr));
                    }
                    autoBootstrap = Boolean.valueOf(autoBootstr);
                } else {
                    throw new ConfigurationException("Unrecognized value for AutoBootstrap.  Use 'true' or 'false'.");
                }
            }
            if ((lifetime = xmlUtils.getNodeValue("/Storage/MemtableFlushAfterMinutes")) != null) {
                memtableLifetimeMs = Integer.parseInt(lifetime) * 60 * 1000;
            }
            if ((memtableSize = xmlUtils.getNodeValue("/Storage/MemtableThroughputInMB")) != null) {
                memtableThroughput = Integer.parseInt(memtableSize);
            }
            if ((memtableObjectCount = xmlUtils.getNodeValue("/Storage/MemtableOperationsInMillions")) != null) {
                memtableOperations = Double.parseDouble(memtableObjectCount);
            }
            if (memtableOperations <= 0.0) {
                throw new ConfigurationException("Memtable object count must be a positive double");
            }
            String doConsistency = xmlUtils.getNodeValue("/Storage/DoConsistencyChecksBoolean");
            if (doConsistency != null) {
                doConsistencyCheck = Boolean.parseBoolean(doConsistency);
            }
            columnIndexSizeInKB = (columnIndexSize = xmlUtils.getNodeValue("/Storage/ColumnIndexSizeInKB")) == null ? 64 : Integer.parseInt(columnIndexSize);
            String rowWarning = xmlUtils.getNodeValue("/Storage/RowWarningThresholdInMB");
            if (rowWarning != null && (rowWarningThreshold = Long.parseLong(rowWarning) * 1024L * 1024L) <= 0L) {
                throw new ConfigurationException("Row warning threshold must be a positive integer");
            }
            dataFileDirectories = xmlUtils.getNodeValues("/Storage/DataFileDirectories/DataFileDirectory");
            logFileDirectory = xmlUtils.getNodeValue("/Storage/CommitLogDirectory");
            for (String datadir : dataFileDirectories) {
                if (!datadir.equals(logFileDirectory)) continue;
                throw new ConfigurationException("CommitLogDirectory must not be the same as any DataFileDirectory");
            }
            String value = xmlUtils.getNodeValue("/Storage/CommitLogRotationThresholdInMB");
            if (value != null) {
                CommitLog.setSegmentSize(Integer.parseInt(value) * 1024 * 1024);
            }
            DatabaseDescriptor.readTablesFromXml();
            if (tables.isEmpty()) {
                throw new ConfigurationException("No keyspaces configured");
            }
            KSMetaData systemMeta = new KSMetaData("system", null, -1, null);
            tables.put("system", systemMeta);
            systemMeta.cfMetaData.put("LocationInfo", new CFMetaData("system", "LocationInfo", "Standard", new UTF8Type(), null, "persistent metadata for the local node", 0.0, 0.01));
            systemMeta.cfMetaData.put("HintsColumnFamily", new CFMetaData("system", "HintsColumnFamily", "Super", new UTF8Type(), new BytesType(), "hinted handoff data", 0.0, 0.01));
            String[] seedsxml = xmlUtils.getNodeValues("/Storage/Seeds/Seed");
            if (seedsxml.length <= 0) {
                throw new ConfigurationException("A minimum of one seed is required.");
            }
            for (int i = 0; i < seedsxml.length; ++i) {
                seeds.add(InetAddress.getByName(seedsxml[i]));
            }
        }
        catch (ConfigurationException e) {
            logger.error((Object)("Fatal error: " + e.getMessage()));
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ConfigurationException
    extends Exception {
        public ConfigurationException(String message) {
            super(message);
        }
    }

    public static enum DiskAccessMode {
        auto,
        mmap,
        mmap_index_only,
        standard;

    }

    public static enum CommitLogSync {
        periodic,
        batch;

    }
}

