/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.utils.FBUtilities;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> repStratClass;
    public final int replicationFactor;
    public final IEndPointSnitch epSnitch;
    public final Map<String, CFMetaData> cfMetaData = new HashMap<String, CFMetaData>();

    KSMetaData(String name, Class<? extends AbstractReplicationStrategy> repStratClass, int replicationFactor, IEndPointSnitch epSnitch) {
        this.name = name;
        this.repStratClass = repStratClass;
        this.replicationFactor = replicationFactor;
        this.epSnitch = epSnitch;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)obj;
        return other.name.equals(this.name) && FBUtilities.equals(other.repStratClass, this.repStratClass) && other.replicationFactor == this.replicationFactor && KSMetaData.sameEpSnitch(other, this) && other.cfMetaData.size() == this.cfMetaData.size() && ((Object)other.cfMetaData).equals(this.cfMetaData);
    }

    private static boolean sameEpSnitch(KSMetaData a, KSMetaData b) {
        if (a.epSnitch == null && b.epSnitch == null) {
            return true;
        }
        if (a.epSnitch == null && b.epSnitch != null) {
            return false;
        }
        if (a.epSnitch != null && b.epSnitch == null) {
            return false;
        }
        return a.epSnitch.getClass().getName().equals(b.epSnitch.getClass().getName());
    }

    public static byte[] serialize(KSMetaData ksm) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(ksm.name);
        dout.writeBoolean(ksm.repStratClass != null);
        if (ksm.repStratClass != null) {
            dout.writeUTF(ksm.repStratClass.getName());
        }
        dout.writeInt(ksm.replicationFactor);
        dout.writeBoolean(ksm.epSnitch != null);
        if (ksm.epSnitch != null) {
            dout.writeUTF(ksm.epSnitch.getClass().getName());
        }
        dout.writeInt(ksm.cfMetaData.size());
        for (CFMetaData cfm : ksm.cfMetaData.values()) {
            dout.write(CFMetaData.serialize(cfm));
        }
        dout.close();
        return bout.toByteArray();
    }

    public static KSMetaData deserialize(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        String name = din.readUTF();
        Class<?> repStratClass = null;
        try {
            repStratClass = din.readBoolean() ? Class.forName(din.readUTF()) : null;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        int replicationFactor = din.readInt();
        IEndPointSnitch epSnitch = null;
        try {
            epSnitch = din.readBoolean() ? (IEndPointSnitch)Class.forName(din.readUTF()).newInstance() : null;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        int cfsz = din.readInt();
        KSMetaData ksm = new KSMetaData(name, repStratClass, replicationFactor, epSnitch);
        for (int i = 0; i < cfsz; ++i) {
            try {
                CFMetaData cfm = CFMetaData.deserialize(din);
                ksm.cfMetaData.put(cfm.cfName, cfm);
                continue;
            }
            catch (IOException ex) {
                System.err.println(ksm.name);
                throw ex;
            }
        }
        return ksm;
    }
}

