/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IFlushable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.log4j.Logger;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class BinaryMemtable
implements IFlushable {
    private static final Logger logger = Logger.getLogger(BinaryMemtable.class);
    private final int threshold = DatabaseDescriptor.getBMTThreshold() * 1024 * 1024;
    private final AtomicInteger currentSize = new AtomicInteger(0);
    private boolean isFrozen = false;
    private final Map<DecoratedKey, byte[]> columnFamilies = new NonBlockingHashMap();
    private final Lock lock = new ReentrantLock();
    Condition condition;
    private final IPartitioner partitioner = StorageService.getPartitioner();
    private final ColumnFamilyStore cfs;

    public BinaryMemtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.condition = this.lock.newCondition();
    }

    boolean isThresholdViolated() {
        return this.currentSize.get() >= this.threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String key, byte[] buffer) throws IOException {
        if (this.isThresholdViolated()) {
            this.lock.lock();
            try {
                if (!this.isFrozen) {
                    this.isFrozen = true;
                    this.cfs.submitFlush(this);
                    this.cfs.switchBinaryMemtable(key, buffer);
                }
                this.cfs.applyBinary(key, buffer);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.resolve(key, buffer);
        }
    }

    public boolean isClean() {
        return this.columnFamilies.isEmpty();
    }

    private void resolve(String key, byte[] buffer) {
        this.columnFamilies.put(this.partitioner.decorateKey(key), buffer);
        this.currentSize.addAndGet(buffer.length + key.length());
    }

    private List<DecoratedKey> getSortedKeys() {
        assert (!this.columnFamilies.isEmpty());
        logger.info((Object)("Sorting " + this));
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>(this.columnFamilies.keySet());
        Collections.sort(keys);
        return keys;
    }

    private SSTableReader writeSortedContents(List<DecoratedKey> sortedKeys) throws IOException {
        logger.info((Object)("Writing " + this));
        String path = this.cfs.getFlushPath();
        SSTableWriter writer = new SSTableWriter(path, sortedKeys.size(), StorageService.getPartitioner());
        for (DecoratedKey key : sortedKeys) {
            byte[] bytes = this.columnFamilies.get(key);
            assert (bytes.length > 0);
            writer.append(key, bytes);
        }
        SSTableReader sstable = writer.closeAndOpenReader();
        logger.info((Object)("Completed flushing " + writer.getFilename()));
        return sstable;
    }

    @Override
    public void flushAndSignal(final Condition condition, ExecutorService sorter, final ExecutorService writer) {
        sorter.submit(new Runnable(){

            @Override
            public void run() {
                final List sortedKeys = BinaryMemtable.this.getSortedKeys();
                writer.submit(new WrappedRunnable(){

                    @Override
                    public void runMayThrow() throws IOException {
                        BinaryMemtable.this.cfs.addSSTable(BinaryMemtable.this.writeSortedContents(sortedKeys));
                        condition.signalAll();
                    }
                });
            }
        });
    }
}

