/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.SSTableReader;

public class ColumnFamilySerializer
implements ICompactSerializer2<ColumnFamily> {
    @Override
    public void serialize(ColumnFamily columnFamily, DataOutput dos) {
        try {
            if (columnFamily == null) {
                dos.writeUTF("");
                return;
            }
            dos.writeUTF(columnFamily.name());
            dos.writeUTF(columnFamily.type_);
            dos.writeUTF(columnFamily.getComparatorName());
            dos.writeUTF(columnFamily.getSubComparatorName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.serializeForSSTable(columnFamily, dos);
    }

    public void serializeForSSTable(ColumnFamily columnFamily, DataOutput dos) {
        try {
            dos.writeInt(columnFamily.localDeletionTime.get());
            dos.writeLong(columnFamily.markedForDeleteAt.get());
            Collection<IColumn> columns = columnFamily.getSortedColumns();
            dos.writeInt(columns.size());
            for (IColumn column : columns) {
                columnFamily.getColumnSerializer().serialize(column, dos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serializeWithIndexes(ColumnFamily columnFamily, DataOutput dos) {
        ColumnIndexer.serialize(columnFamily, dos);
        this.serializeForSSTable(columnFamily, dos);
    }

    @Override
    public ColumnFamily deserialize(DataInput dis) throws IOException {
        String cfName = dis.readUTF();
        if (cfName.isEmpty()) {
            return null;
        }
        ColumnFamily cf = this.deserializeFromSSTableNoColumns(cfName, dis.readUTF(), this.readComparator(dis), this.readComparator(dis), dis);
        this.deserializeColumns(dis, cf);
        return cf;
    }

    private void deserializeColumns(DataInput dis, ColumnFamily cf) throws IOException {
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            IColumn column = cf.getColumnSerializer().deserialize(dis);
            cf.addColumn(column);
        }
    }

    private AbstractType readComparator(DataInput dis) throws IOException {
        String className = dis.readUTF();
        if (className.equals("")) {
            return null;
        }
        try {
            return (AbstractType)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load comparator class '" + className + "'.  probably this means you have obsolete sstables lying around", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnFamily deserializeFromSSTableNoColumns(String name, String type, AbstractType comparator, AbstractType subComparator, DataInput input) throws IOException {
        ColumnFamily cf = new ColumnFamily(name, type, comparator, subComparator);
        return this.deserializeFromSSTableNoColumns(cf, input);
    }

    public ColumnFamily deserializeFromSSTableNoColumns(ColumnFamily cf, DataInput input) throws IOException {
        cf.delete(input.readInt(), input.readLong());
        return cf;
    }

    public ColumnFamily deserializeFromSSTable(SSTableReader sstable, DataInput file) throws IOException {
        ColumnFamily cf = sstable.makeColumnFamily();
        this.deserializeFromSSTableNoColumns(cf, file);
        this.deserializeColumns(file, cf);
        return cf;
    }
}

