/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BinaryMemtable;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IFlushable;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.IdentityQueryFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IndexSummary;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableScanner;
import org.apache.cassandra.io.SSTableTracker;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.collections.IteratorUtils;
import org.apache.log4j.Logger;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static Logger logger_ = Logger.getLogger(ColumnFamilyStore.class);
    private static ExecutorService flushSorter_ = new JMXEnabledThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1 + Runtime.getRuntime().availableProcessors()), new NamedThreadFactory("FLUSH-SORTER-POOL"));
    private static ExecutorService flushWriter_ = new JMXEnabledThreadPoolExecutor(1, DatabaseDescriptor.getAllDataFileLocations().length, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1 + 2 * DatabaseDescriptor.getAllDataFileLocations().length), new NamedThreadFactory("FLUSH-WRITER-POOL"));
    private static ExecutorService commitLogUpdater_ = new JMXEnabledThreadPoolExecutor("MEMTABLE-POST-FLUSHER");
    private static final int KEY_RANGE_FILE_BUFFER_SIZE = 262144;
    private Set<Memtable> memtablesPendingFlush = new ConcurrentSkipListSet<Memtable>();
    private final String table_;
    public final String columnFamily_;
    private final boolean isSuper_;
    private volatile Integer memtableSwitchCount = 0;
    private AtomicInteger fileIndexGenerator_ = new AtomicInteger(0);
    private Memtable memtable_;
    private AtomicReference<BinaryMemtable> binaryMemtable_;
    private SSTableTracker ssTables_;
    private LatencyTracker readStats_ = new LatencyTracker();
    private LatencyTracker writeStats_ = new LatencyTracker();
    private long minRowCompactedSize = 0L;
    private long maxRowCompactedSize = 0L;
    private long rowsCompactedTotalSize = 0L;
    private long rowsCompactedCount = 0L;

    ColumnFamilyStore(String table, String columnFamilyName, boolean isSuper, int indexValue) throws IOException {
        this.table_ = table;
        this.columnFamily_ = columnFamilyName;
        this.isSuper_ = isSuper;
        this.fileIndexGenerator_.set(indexValue);
        this.memtable_ = new Memtable(this);
        this.binaryMemtable_ = new AtomicReference<BinaryMemtable>(new BinaryMemtable(this));
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Starting CFS " + this.columnFamily_));
        }
        ArrayList<File> sstableFiles = new ArrayList<File>();
        Pattern auxFilePattern = Pattern.compile("(.*)(-Filter\\.db$|-Index\\.db$)");
        for (File file : this.files()) {
            String basePath;
            String filename = file.getName();
            Matcher matcher = auxFilePattern.matcher(file.getAbsolutePath());
            if (matcher.matches() && !new File((basePath = matcher.group(1)) + "-Data.db").exists()) {
                logger_.info((Object)String.format("Removing orphan %s", file.getAbsolutePath()));
                FileUtils.deleteWithConfirm(file);
                continue;
            }
            if (file.length() == 0L && !filename.endsWith("-Compacted") || filename.contains("-tmp")) {
                FileUtils.deleteWithConfirm(file);
                continue;
            }
            if (!filename.contains("-Data.db")) continue;
            sstableFiles.add(file.getAbsoluteFile());
        }
        Collections.sort(sstableFiles, new FileUtils.FileComparator());
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        for (File file : sstableFiles) {
            SSTableReader sstable;
            String filename = file.getAbsolutePath();
            if (SSTable.deleteIfCompacted(filename)) continue;
            try {
                sstable = SSTableReader.open(filename);
            }
            catch (IOException ex) {
                logger_.error((Object)("Corrupt file " + filename + "; skipped"), (Throwable)ex);
                continue;
            }
            sstables.add(sstable);
        }
        this.ssTables_ = new SSTableTracker(table, columnFamilyName);
        this.ssTables_.add(sstables);
    }

    public void addToCompactedRowStats(Long rowsize) {
        if (this.minRowCompactedSize < 1L || rowsize < this.minRowCompactedSize) {
            this.minRowCompactedSize = rowsize;
        }
        if (rowsize > this.maxRowCompactedSize) {
            this.maxRowCompactedSize = rowsize;
        }
        ++this.rowsCompactedCount;
        this.rowsCompactedTotalSize += rowsize.longValue();
    }

    @Override
    public long getMinRowCompactedSize() {
        return this.minRowCompactedSize;
    }

    @Override
    public long getMaxRowCompactedSize() {
        return this.maxRowCompactedSize;
    }

    @Override
    public long getMeanRowCompactedSize() {
        if (this.rowsCompactedCount > 0L) {
            return this.rowsCompactedTotalSize / this.rowsCompactedCount;
        }
        return 0L;
    }

    public static ColumnFamilyStore createColumnFamilyStore(String table, String columnFamily) throws IOException {
        String[] dataFileDirectories;
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (String directory : dataFileDirectories = DatabaseDescriptor.getAllDataFileLocationsForTable(table)) {
            File[] files;
            File fileDir = new File(directory);
            for (File file : files = fileDir.listFiles()) {
                String filename = file.getName();
                String cfName = ColumnFamilyStore.getColumnFamilyFromFileName(filename);
                if (!cfName.equals(columnFamily)) continue;
                generations.add(ColumnFamilyStore.getGenerationFromFileName(filename));
            }
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        ColumnFamilyStore cfs = new ColumnFamilyStore(table, columnFamily, "Super".equals(DatabaseDescriptor.getColumnType(table, columnFamily)), value);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String mbeanName = "org.apache.cassandra.db:type=ColumnFamilyStores,keyspace=" + table + ",columnfamily=" + columnFamily;
            mbs.registerMBean(cfs, new ObjectName(mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cfs;
    }

    private Set<File> files() {
        HashSet<File> fileSet = new HashSet<File>();
        for (String directory : DatabaseDescriptor.getAllDataFileLocationsForTable(this.table_)) {
            File[] files;
            for (File file : files = new File(directory).listFiles()) {
                String cfName = ColumnFamilyStore.getColumnFamilyFromFileName(file.getName());
                if (!cfName.equals(this.columnFamily_)) continue;
                fileSet.add(file);
            }
        }
        return fileSet;
    }

    @Override
    public String getColumnFamilyName() {
        return this.columnFamily_;
    }

    private static String getColumnFamilyFromFileName(String filename) {
        return filename.split("-")[0];
    }

    public static int getGenerationFromFileName(String filename) {
        StringTokenizer st = new StringTokenizer(filename, "-");
        int count = st.countTokens();
        int i = 0;
        String index = null;
        while (st.hasMoreElements()) {
            index = (String)st.nextElement();
            if (i == count - 2) break;
            ++i;
        }
        return Integer.parseInt(index);
    }

    public String getFlushPath() {
        long guessedSize = 2 * DatabaseDescriptor.getMemtableThroughput() * 1024 * 1024;
        String location = DatabaseDescriptor.getDataFileLocationForTable(this.table_, guessedSize);
        if (location == null) {
            throw new RuntimeException("Insufficient disk space to flush");
        }
        return new File(location, this.getTempSSTableFileName()).getAbsolutePath();
    }

    public String getTempSSTableFileName() {
        return String.format("%s-%s-%s-Data.db", this.columnFamily_, "tmp", this.fileIndexGenerator_.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<?> maybeSwitchMemtable(Memtable oldMemtable, final boolean writeCommitLog) throws IOException {
        Table.flusherLock.writeLock().lock();
        try {
            if (oldMemtable.isFrozen()) {
                Future<?> future = null;
                return future;
            }
            oldMemtable.freeze();
            final CommitLogSegment.CommitLogContext ctx = writeCommitLog ? CommitLog.instance().getContext() : null;
            logger_.info((Object)(this.columnFamily_ + " has reached its threshold; switching in a fresh Memtable at " + ctx));
            final Condition condition = this.submitFlush(oldMemtable);
            this.memtable_ = new Memtable(this);
            Future<?> future = commitLogUpdater_.submit(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws InterruptedException, IOException {
                    condition.await();
                    if (writeCommitLog) {
                        CommitLog.instance().discardCompletedSegments(ColumnFamilyStore.this.table_, ColumnFamilyStore.this.columnFamily_, ctx);
                    }
                }
            });
            return future;
        }
        finally {
            Table.flusherLock.writeLock().unlock();
            if (this.memtableSwitchCount == Integer.MAX_VALUE) {
                this.memtableSwitchCount = 0;
            }
            Integer n = this.memtableSwitchCount;
            Integer n2 = this.memtableSwitchCount = Integer.valueOf(this.memtableSwitchCount + 1);
        }
    }

    void switchBinaryMemtable(String key, byte[] buffer) throws IOException {
        this.binaryMemtable_.set(new BinaryMemtable(this));
        this.binaryMemtable_.get().put(key, buffer);
    }

    public void forceFlushIfExpired() throws IOException {
        if (this.memtable_.isExpired()) {
            this.forceFlush();
        }
    }

    @Override
    public Future<?> forceFlush() throws IOException {
        if (this.memtable_.isClean()) {
            return null;
        }
        return this.maybeSwitchMemtable(this.memtable_, true);
    }

    public void forceBlockingFlush() throws IOException, ExecutionException, InterruptedException {
        Object future = this.forceFlush();
        if (future != null) {
            future.get();
        }
    }

    public void forceFlushBinary() {
        if (this.binaryMemtable_.get().isClean()) {
            return;
        }
        this.submitFlush(this.binaryMemtable_.get());
    }

    Memtable apply(String key, ColumnFamily columnFamily) throws IOException {
        long start = System.nanoTime();
        boolean flushRequested = this.memtable_.isThresholdViolated();
        this.memtable_.put(key, columnFamily);
        this.writeStats_.addNano(System.nanoTime() - start);
        return flushRequested ? this.memtable_ : null;
    }

    void applyBinary(String key, byte[] buffer) throws IOException {
        long start = System.nanoTime();
        this.binaryMemtable_.get().put(key, buffer);
        this.writeStats_.addNano(System.nanoTime() - start);
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        if (cf == null) {
            return null;
        }
        if (cf.isSuper()) {
            ColumnFamilyStore.removeDeletedSuper(cf, gcBefore);
        } else {
            ColumnFamilyStore.removeDeletedStandard(cf, gcBefore);
        }
        if (cf.getColumnCount() == 0 && cf.getLocalDeletionTime() <= gcBefore) {
            return null;
        }
        return cf;
    }

    private static void removeDeletedStandard(ColumnFamily cf, int gcBefore) {
        for (byte[] cname : cf.getColumnNames()) {
            IColumn c = cf.getColumnsMap().get(cname);
            if ((!c.isMarkedForDelete() || c.getLocalDeletionTime() > gcBefore) && c.timestamp() > cf.getMarkedForDeleteAt()) continue;
            cf.remove(cname);
        }
    }

    private static void removeDeletedSuper(ColumnFamily cf, int gcBefore) {
        for (byte[] cname : cf.getColumnNames()) {
            IColumn c = cf.getColumnsMap().get(cname);
            long minTimestamp = Math.max(c.getMarkedForDeleteAt(), cf.getMarkedForDeleteAt());
            for (IColumn subColumn : c.getSubColumns()) {
                if (subColumn.timestamp() > minTimestamp && (!subColumn.isMarkedForDelete() || subColumn.getLocalDeletionTime() > gcBefore)) continue;
                ((SuperColumn)c).remove(subColumn.name());
            }
            if (!c.getSubColumns().isEmpty() || c.getLocalDeletionTime() > gcBefore) continue;
            cf.remove(c.name());
        }
    }

    public void addSSTable(SSTableReader sstable) {
        this.ssTables_.add(Arrays.asList(sstable));
        CompactionManager.instance.submitMinorIfNeeded(this);
    }

    long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables) {
        long expectedFileSize = 0L;
        for (SSTableReader sstable : sstables) {
            long size = sstable.length();
            expectedFileSize += size;
        }
        return expectedFileSize;
    }

    SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.length() <= maxSize) continue;
            maxSize = sstable.length();
            maxFile = sstable;
        }
        return maxFile;
    }

    void forceCleanup() {
        CompactionManager.instance.submitCleanup(this);
    }

    public Table getTable() {
        try {
            return Table.open(this.table_);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void markCompacted(Collection<SSTableReader> sstables) throws IOException {
        this.ssTables_.markCompacted(sstables);
    }

    boolean isCompleteSSTables(Collection<SSTableReader> sstables) {
        return ((Object)this.ssTables_.getSSTables()).equals(new HashSet<SSTableReader>(sstables));
    }

    void replaceCompactedSSTables(Collection<SSTableReader> sstables, Iterable<SSTableReader> replacements) throws IOException {
        this.ssTables_.replace(sstables, replacements);
    }

    Condition submitFlush(IFlushable flushable) {
        logger_.info((Object)("Enqueuing flush of " + flushable));
        SimpleCondition condition = new SimpleCondition();
        flushable.flushAndSignal(condition, flushSorter_, flushWriter_);
        return condition;
    }

    public boolean isSuper() {
        return this.isSuper_;
    }

    @Override
    public int getMemtableColumnsCount() {
        return this.getMemtableThreadSafe().getCurrentOperations();
    }

    @Override
    public int getMemtableDataSize() {
        return this.getMemtableThreadSafe().getCurrentThroughput();
    }

    @Override
    public int getMemtableSwitchCount() {
        return this.memtableSwitchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memtable getMemtableThreadSafe() {
        Table.flusherLock.readLock().lock();
        try {
            Memtable memtable = this.memtable_;
            return memtable;
        }
        finally {
            Table.flusherLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DecoratedKey> memtableKeyIterator(DecoratedKey startWith) throws ExecutionException, InterruptedException {
        Table.flusherLock.readLock().lock();
        try {
            Iterator<DecoratedKey> iterator = this.memtable_.getKeyIterator(startWith);
            return iterator;
        }
        finally {
            Table.flusherLock.readLock().unlock();
        }
    }

    public Collection<SSTableReader> getSSTables() {
        return this.ssTables_.getSSTables();
    }

    @Override
    public long getReadCount() {
        return this.readStats_.getOpCount();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return this.readStats_.getRecentLatencyMicros();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return this.readStats_.getTotalLatencyMicros();
    }

    @Override
    public int getPendingTasks() {
        return Table.flusherLock.getQueueLength();
    }

    @Override
    public long getWriteCount() {
        return this.writeStats_.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return this.writeStats_.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return this.writeStats_.getRecentLatencyMicros();
    }

    public ColumnFamily getColumnFamily(String key, QueryPath path, byte[] start, byte[] finish, boolean reversed, int limit) throws IOException {
        return this.getColumnFamily(new SliceQueryFilter(key, path, start, finish, reversed, limit));
    }

    public ColumnFamily getColumnFamily(QueryFilter filter) throws IOException {
        return this.getColumnFamily(filter, CompactionManager.getDefaultGCBefore());
    }

    private ColumnFamily cacheRow(String key) throws IOException {
        ColumnFamily cached = (ColumnFamily)this.ssTables_.getRowCache().get(key);
        if (cached == null) {
            cached = this.getTopLevelColumns(new IdentityQueryFilter(key, new QueryPath(this.columnFamily_)), Integer.MIN_VALUE);
            if (cached == null) {
                return null;
            }
            this.ssTables_.getRowCache().put(key, cached);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnFamily getColumnFamily(QueryFilter filter, int gcBefore) throws IOException {
        assert (this.columnFamily_.equals(filter.getColumnFamilyName()));
        long start = System.nanoTime();
        try {
            SuperColumn sc;
            ColumnFamily cf;
            if (filter.path.superColumnName == null) {
                if (this.ssTables_.getRowCache().getCapacity() == 0) {
                    ColumnFamily columnFamily = ColumnFamilyStore.removeDeleted(this.getTopLevelColumns(filter, gcBefore), gcBefore);
                    return columnFamily;
                }
                ColumnFamily cached = this.cacheRow(filter.key);
                ColumnIterator ci = filter.getMemColumnIterator(this.memtable_, cached, this.getComparator());
                ColumnFamily returnCF = ci.getColumnFamily();
                filter.collectCollatedColumns(returnCF, ci, gcBefore);
                ColumnFamily columnFamily = ColumnFamilyStore.removeDeleted(returnCF, gcBefore);
                return columnFamily;
            }
            if (this.ssTables_.getRowCache().getCapacity() == 0) {
                NamesQueryFilter nameFilter = new NamesQueryFilter(filter.key, new QueryPath(this.columnFamily_), filter.path.superColumnName);
                cf = this.getTopLevelColumns(nameFilter, gcBefore);
                if (cf == null || cf.getColumnCount() == 0) {
                    ColumnFamily columnFamily = cf;
                    return columnFamily;
                }
                assert (cf.getSortedColumns().size() == 1);
                sc = (SuperColumn)cf.getSortedColumns().iterator().next();
            } else {
                cf = this.cacheRow(filter.key);
                if (cf == null) {
                    ColumnFamily nameFilter = null;
                    return nameFilter;
                }
                sc = (SuperColumn)cf.getColumn(filter.path.superColumnName);
                if (sc == null) {
                    ColumnFamily nameFilter = null;
                    return nameFilter;
                }
                sc = (SuperColumn)sc.cloneMe();
            }
            long deletedAt = sc.getMarkedForDeleteAt();
            if (cf.getMarkedForDeleteAt() > deletedAt) {
                sc.markForDeleteAt(sc.getLocalDeletionTime(), cf.getMarkedForDeleteAt());
            }
            SuperColumn scFiltered = filter.filterSuperColumn(sc, gcBefore);
            ColumnFamily cfFiltered = cf.cloneMeShallow();
            scFiltered.markForDeleteAt(sc.getLocalDeletionTime(), deletedAt);
            cfFiltered.addColumn(scFiltered);
            ColumnFamily columnFamily = ColumnFamilyStore.removeDeleted(cfFiltered, gcBefore);
            return columnFamily;
        }
        finally {
            this.readStats_.addNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore) throws IOException {
        ArrayList<ColumnIterator> iterators = new ArrayList<ColumnIterator>();
        try {
            ColumnFamily returnCF;
            ColumnIterator iter;
            Table.flusherLock.readLock().lock();
            try {
                iter = filter.getMemColumnIterator(this.memtable_, this.getComparator());
                returnCF = iter.getColumnFamily();
            }
            finally {
                Table.flusherLock.readLock().unlock();
            }
            iterators.add(iter);
            for (Memtable memtable : this.getMemtablesPendingFlush()) {
                iter = filter.getMemColumnIterator(memtable, this.getComparator());
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            for (SSTableReader sstable : this.ssTables_) {
                iter = filter.getSSTableColumnIterator(sstable);
                if (iter.hasNext()) {
                    returnCF.delete(iter.getColumnFamily());
                }
                iterators.add(iter);
            }
            Comparator<IColumn> comparator = filter.getColumnComparator(this.getComparator());
            Iterator collated = IteratorUtils.collatedIterator(comparator, iterators);
            if (!collated.hasNext()) {
                ColumnFamily columnFamily = null;
                return columnFamily;
            }
            filter.collectCollatedColumns(returnCF, collated, gcBefore);
            ColumnFamily columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (ColumnIterator ci : iterators) {
                try {
                    ci.close();
                }
                catch (Throwable th) {
                    logger_.error((Object)("error closing " + ci), th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getKeyRange(List<String> keys, AbstractBounds range, int maxResults) throws IOException, ExecutionException, InterruptedException {
        final DecoratedKey<Token> startWith = new DecoratedKey<Token>(range.left, null);
        final DecoratedKey<Token> stopAt = new DecoratedKey<Token>(range.right, null);
        ArrayList<Object> iterators = new ArrayList<Object>();
        Predicate<DecoratedKey> p = new Predicate<DecoratedKey>(){

            public boolean apply(DecoratedKey key) {
                return startWith.compareTo(key) <= 0 && (stopAt.isEmpty() || key.compareTo(stopAt) <= 0);
            }
        };
        iterators.add(Iterators.filter(this.memtableKeyIterator(startWith), (Predicate)p));
        for (Memtable memtable : this.memtablesPendingFlush) {
            iterators.add(Iterators.filter(memtable.getKeyIterator(startWith), (Predicate)p));
        }
        for (SSTableReader sstable : this.ssTables_) {
            final SSTableScanner scanner = sstable.getScanner(262144);
            scanner.seekTo(startWith);
            CloseableIterator<DecoratedKey> iter = new CloseableIterator<DecoratedKey>(){

                @Override
                public boolean hasNext() {
                    return scanner.hasNext();
                }

                @Override
                public DecoratedKey next() {
                    return scanner.next().getKey();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() throws IOException {
                    scanner.close();
                }
            };
            assert (iter instanceof Closeable);
            iterators.add(iter);
        }
        Iterator collated = IteratorUtils.collatedIterator(DecoratedKey.comparator, iterators);
        ReducingIterator<DecoratedKey, DecoratedKey> reduced = new ReducingIterator<DecoratedKey, DecoratedKey>(collated){
            DecoratedKey current;

            @Override
            public void reduce(DecoratedKey current) {
                this.current = current;
            }

            @Override
            protected DecoratedKey getReduced() {
                return this.current;
            }
        };
        try {
            boolean first = true;
            for (DecoratedKey current : reduced) {
                if (!stopAt.isEmpty() && stopAt.compareTo(current) < 0) {
                    boolean bl = true;
                    return bl;
                }
                if (range instanceof Bounds || !first || !current.equals(startWith)) {
                    keys.add(current.key);
                }
                first = false;
                if (keys.size() < maxResults) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            for (Iterator iterator : iterators) {
                if (!(iterator instanceof Closeable)) continue;
                ((Closeable)((Object)iterator)).close();
            }
        }
    }

    public RangeSliceReply getRangeSlice(byte[] super_column, AbstractBounds range, int keyMax, SliceRange sliceRange, List<byte[]> columnNames) throws IOException, ExecutionException, InterruptedException {
        boolean completed;
        ArrayList<String> keys = new ArrayList<String>();
        if (range instanceof Bounds || !((Range)range).isWrapAround()) {
            completed = this.getKeyRange(keys, range, keyMax);
        } else {
            Object min = StorageService.getPartitioner().getMinimumToken();
            Range first = new Range(range.left, (Token)min);
            completed = this.getKeyRange(keys, first, keyMax);
            if (!completed && ((Token)min).compareTo(range.right) < 0) {
                Range second = new Range((Token)min, range.right);
                this.getKeyRange(keys, second, keyMax);
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>(keys.size());
        QueryPath queryPath = new QueryPath(this.columnFamily_, super_column, null);
        TreeSet<byte[]> columnNameSet = new TreeSet<byte[]>(this.getComparator());
        if (columnNames != null) {
            columnNameSet.addAll(columnNames);
        }
        for (String key : keys) {
            QueryFilter filter = sliceRange == null ? new NamesQueryFilter(key, queryPath, columnNameSet) : new SliceQueryFilter(key, queryPath, sliceRange.start, sliceRange.finish, sliceRange.reversed, sliceRange.count);
            rows.add(new Row(key, this.getColumnFamily(filter)));
        }
        return new RangeSliceReply(rows);
    }

    public AbstractType getComparator() {
        return DatabaseDescriptor.getComparator(this.table_, this.columnFamily_);
    }

    public void snapshot(String snapshotName) throws IOException {
        try {
            this.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        for (SSTableReader ssTable : this.ssTables_) {
            File sourceFile = new File(ssTable.getFilename());
            File dataDirectory = sourceFile.getParentFile().getParentFile();
            String snapshotDirectoryPath = Table.getSnapshotPath(dataDirectory.getAbsolutePath(), this.table_, snapshotName);
            FileUtils.createDirectory(snapshotDirectoryPath);
            File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            FileUtils.createHardLink(sourceFile, targetLink);
            sourceFile = new File(ssTable.indexFilename());
            targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            FileUtils.createHardLink(sourceFile, targetLink);
            sourceFile = new File(ssTable.filterFilename());
            targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            FileUtils.createHardLink(sourceFile, targetLink);
            if (!logger_.isDebugEnabled()) continue;
            logger_.debug((Object)("Snapshot for " + this.table_ + " table data file " + sourceFile.getAbsolutePath() + " created as " + targetLink.getAbsolutePath()));
        }
    }

    public boolean hasUnreclaimedSpace() {
        return this.ssTables_.getLiveSize() < this.ssTables_.getTotalSize();
    }

    @Override
    public long getTotalDiskSpaceUsed() {
        return this.ssTables_.getTotalSize();
    }

    @Override
    public long getLiveDiskSpaceUsed() {
        return this.ssTables_.getLiveSize();
    }

    @Override
    public int getLiveSSTableCount() {
        return this.ssTables_.size();
    }

    public ColumnFamily getRawCachedRow(String key) {
        return this.ssTables_.getRowCache().getCapacity() == 0 ? null : (ColumnFamily)this.ssTables_.getRowCache().getInternal(key);
    }

    void invalidateCachedRow(String key) {
        this.ssTables_.getRowCache().remove(key);
    }

    @Override
    public void forceMajorCompaction() {
        CompactionManager.instance.submitMajor(this);
    }

    @Override
    public void invalidateRowCache() {
        this.ssTables_.getRowCache().clear();
    }

    public static Iterable<ColumnFamilyStore> all() {
        Iterable[] stores = new Iterable[DatabaseDescriptor.getTables().size()];
        int i = 0;
        for (Table table : Table.all()) {
            stores[i++] = table.getColumnFamilyStores();
        }
        return Iterables.concat((Iterable[])stores);
    }

    public Iterable<IndexSummary.KeyPosition> allIndexPositions() {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] positions = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            positions[i++] = sstable.getIndexPositions();
        }
        return Iterables.concat((Iterable[])positions);
    }

    void clearUnsafe() {
        this.memtable_.clearUnsafe();
        this.ssTables_.clearUnsafe();
    }

    public Set<Memtable> getMemtablesPendingFlush() {
        return this.memtablesPendingFlush;
    }
}

