/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IndexHelper;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.BloomFilter;

public class ColumnIndexer {
    public static void serialize(ColumnFamily columnFamily, DataOutput dos) {
        Collection<IColumn> columns = columnFamily.getSortedColumns();
        BloomFilter bf = ColumnIndexer.createColumnBloomFilter(columns);
        DataOutputBuffer bufOut = new DataOutputBuffer();
        try {
            BloomFilter.serializer().serialize(bf, bufOut);
            dos.writeInt(bufOut.getLength());
            dos.write(bufOut.getData(), 0, bufOut.getLength());
            ColumnIndexer.doIndexing(columnFamily.getComparator(), columns, dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BloomFilter createColumnBloomFilter(Collection<IColumn> columns) {
        int columnCount = 0;
        for (IColumn column : columns) {
            columnCount += column.getObjectCount();
        }
        BloomFilter bf = BloomFilter.getFilter((long)columnCount, 4);
        for (IColumn column : columns) {
            bf.add(column.name());
            if (!(column instanceof SuperColumn)) continue;
            Collection<IColumn> subColumns = column.getSubColumns();
            for (IColumn subColumn : subColumns) {
                bf.add(subColumn.name());
            }
        }
        return bf;
    }

    private static void doIndexing(AbstractType comparator, Collection<IColumn> columns, DataOutput dos) throws IOException {
        if (columns.isEmpty()) {
            dos.writeInt(0);
            return;
        }
        ArrayList<IndexHelper.IndexInfo> indexList = new ArrayList<IndexHelper.IndexInfo>();
        int endPosition = 0;
        int startPosition = -1;
        int indexSizeInBytes = 0;
        IColumn column2 = null;
        IColumn firstColumn = null;
        for (IColumn column2 : columns) {
            if (firstColumn == null) {
                firstColumn = column2;
                startPosition = endPosition;
            }
            if ((endPosition += column2.serializedSize()) - startPosition < DatabaseDescriptor.getColumnIndexSize()) continue;
            IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(firstColumn.name(), column2.name(), startPosition, endPosition - startPosition);
            indexList.add(cIndexInfo);
            indexSizeInBytes += cIndexInfo.serializedSize();
            firstColumn = null;
        }
        if (indexList.isEmpty() || comparator.compare(((IndexHelper.IndexInfo)indexList.get((int)(indexList.size() - 1))).lastName, column2.name()) != 0) {
            IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(firstColumn.name(), column2.name(), startPosition, endPosition - startPosition);
            indexList.add(cIndexInfo);
            indexSizeInBytes += cIndexInfo.serializedSize();
        }
        assert (indexSizeInBytes > 0);
        dos.writeInt(indexSizeInBytes);
        for (IndexHelper.IndexInfo cIndexInfo : indexList) {
            cIndexInfo.serialize(dos);
        }
    }
}

