/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.utils.FBUtilities;

public class ColumnSerializer
implements ICompactSerializer2<IColumn> {
    public static void writeName(byte[] name, DataOutput out) {
        int length = name.length;
        assert (0 <= length && length <= 65535);
        try {
            out.writeByte(length >> 8 & 0xFF);
            out.writeByte(length & 0xFF);
            out.write(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readName(DataInput in) throws IOException {
        int length = 0;
        length |= (in.readByte() & 0xFF) << 8;
        if (0 > (length |= in.readByte() & 0xFF) || length > 65535) {
            throw new IOException("Corrupt name length " + length);
        }
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return bytes;
    }

    @Override
    public void serialize(IColumn column, DataOutput dos) {
        ColumnSerializer.writeName(column.name(), dos);
        try {
            dos.writeBoolean(column.isMarkedForDelete());
            dos.writeLong(column.timestamp());
            FBUtilities.writeByteArray(column.value(), dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Column deserialize(DataInput dis) throws IOException {
        byte[] name = ColumnSerializer.readName(dis);
        boolean delete = dis.readBoolean();
        long ts = dis.readLong();
        int length = dis.readInt();
        if (length < 0) {
            throw new IOException("Corrupt (negative) value length encountered");
        }
        byte[] value = new byte[length];
        if (length > 0) {
            dis.readFully(value);
        }
        return new Column(name, value, ts, delete);
    }
}

