/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManagerMBean;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.CompactionIterator;
import org.apache.cassandra.io.IteratingRow;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableScanner;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = Logger.getLogger(CompactionManager.class);
    public static final CompactionManager instance = new CompactionManager();
    private int minimumCompactionThreshold = 4;
    private int maximumCompactionThreshold = 32;
    private CompactionExecutor executor = new CompactionExecutor();
    private Map<ColumnFamilyStore, Integer> estimatedCompactions = new NonBlockingHashMap();

    public Future<Integer> submitMinorIfNeeded(final ColumnFamilyStore cfs) {
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws IOException {
                if (CompactionManager.this.minimumCompactionThreshold <= 0 || CompactionManager.this.maximumCompactionThreshold <= 0) {
                    logger.debug((Object)"Compaction is currently disabled.");
                    return 0;
                }
                logger.debug((Object)("Checking to see if compaction of " + cfs.columnFamily_ + " would be useful"));
                Set<List<SSTableReader>> buckets = CompactionManager.getBuckets(cfs.getSSTables(), 0x3200000L);
                CompactionManager.this.updateEstimateFor(cfs, buckets);
                for (List<SSTableReader> sstables : buckets) {
                    if (sstables.size() < CompactionManager.this.minimumCompactionThreshold) continue;
                    Collections.sort(sstables);
                    return CompactionManager.this.doCompaction(cfs, sstables.subList(0, Math.min(sstables.size(), CompactionManager.this.maximumCompactionThreshold)), CompactionManager.getDefaultGCBefore());
                }
                return 0;
            }
        };
        return this.executor.submit(callable);
    }

    private void updateEstimateFor(ColumnFamilyStore cfs, Set<List<SSTableReader>> buckets) {
        int n = 0;
        for (List<SSTableReader> sstables : buckets) {
            if (sstables.size() < this.minimumCompactionThreshold) continue;
            n += 1 + sstables.size() / (this.maximumCompactionThreshold - this.minimumCompactionThreshold);
        }
        this.estimatedCompactions.put(cfs, n);
    }

    public Future<Object> submitCleanup(final ColumnFamilyStore cfStore) {
        Callable<Object> runnable = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                CompactionManager.this.doCleanupCompaction(cfStore);
                return this;
            }
        };
        return this.executor.submit(runnable);
    }

    public Future<List<SSTableReader>> submitAnticompaction(final ColumnFamilyStore cfStore, final Collection<Range> ranges, final InetAddress target) {
        Callable<List<SSTableReader>> callable = new Callable<List<SSTableReader>>(){

            @Override
            public List<SSTableReader> call() throws IOException {
                return CompactionManager.this.doAntiCompaction(cfStore, cfStore.getSSTables(), ranges, target);
            }
        };
        return this.executor.submit(callable);
    }

    public Future submitMajor(ColumnFamilyStore cfStore) {
        return this.submitMajor(cfStore, 0L, CompactionManager.getDefaultGCBefore());
    }

    public Future submitMajor(final ColumnFamilyStore cfStore, final long skip, final int gcBefore) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                ArrayList<SSTableReader> sstables;
                if (skip > 0L) {
                    sstables = new ArrayList();
                    for (SSTableReader sstable : cfStore.getSSTables()) {
                        if (sstable.length() >= skip * 1024L * 1024L * 1024L) continue;
                        sstables.add(sstable);
                    }
                } else {
                    sstables = cfStore.getSSTables();
                }
                CompactionManager.this.doCompaction(cfStore, sstables, gcBefore);
                return this;
            }
        };
        return this.executor.submit(callable);
    }

    public Future submitReadonly(final ColumnFamilyStore cfStore, final InetAddress initiator) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                CompactionManager.this.doReadonlyCompaction(cfStore, initiator);
                return this;
            }
        };
        return this.executor.submit(callable);
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minimumCompactionThreshold;
    }

    @Override
    public void setMinimumCompactionThreshold(int threshold) {
        this.minimumCompactionThreshold = threshold;
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maximumCompactionThreshold;
    }

    @Override
    public void setMaximumCompactionThreshold(int threshold) {
        this.maximumCompactionThreshold = threshold;
    }

    public void disableAutoCompaction() {
        this.minimumCompactionThreshold = 0;
        this.maximumCompactionThreshold = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) throws IOException {
        SSTableWriter writer;
        Table table = cfs.getTable();
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            table.snapshot("compact-" + cfs.columnFamily_);
        }
        logger.info((Object)("Compacting [" + StringUtils.join(sstables, (String)",") + "]"));
        String compactionFileLocation = table.getDataFileLocation(cfs.getExpectedCompactedFileSize(sstables));
        ArrayList<SSTableReader> smallerSSTables = new ArrayList<SSTableReader>(sstables);
        while (compactionFileLocation == null && smallerSSTables.size() > 1) {
            logger.warn((Object)("insufficient space to compact all requested files " + StringUtils.join(smallerSSTables, (String)", ")));
            smallerSSTables.remove(cfs.getMaxSizeFile(smallerSSTables));
            compactionFileLocation = table.getDataFileLocation(cfs.getExpectedCompactedFileSize(smallerSSTables));
        }
        if (compactionFileLocation == null) {
            logger.error((Object)"insufficient space to compact even the two smallest files, aborting");
            return 0;
        }
        sstables = smallerSSTables;
        boolean major = cfs.isCompleteSSTables(sstables);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        int expectedBloomFilterSize = Math.max(SSTableReader.indexInterval(), (int)SSTableReader.getApproximateKeyCount(sstables));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expected bloom filter size : " + expectedBloomFilterSize));
        }
        CompactionIterator ci = new CompactionIterator(sstables, gcBefore, major);
        FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
        this.executor.beginCompaction(cfs, ci);
        try {
            if (!nni.hasNext()) {
                cfs.markCompacted(sstables);
                int n = 0;
                return n;
            }
            String newFilename = new File(compactionFileLocation, cfs.getTempSSTableFileName()).getAbsolutePath();
            writer = new SSTableWriter(newFilename, expectedBloomFilterSize, StorageService.getPartitioner());
            AntiEntropyService.IValidator validator = AntiEntropyService.instance.getValidator(table.name, cfs.getColumnFamilyName(), null, major);
            validator.prepare();
            while (nni.hasNext()) {
                CompactionIterator.CompactedRow row = (CompactionIterator.CompactedRow)nni.next();
                long prevpos = writer.getFilePointer();
                writer.append(row.key, row.buffer);
                validator.add(row);
                ++totalkeysWritten;
                long rowsize = writer.getFilePointer() - prevpos;
                if (rowsize > DatabaseDescriptor.getRowWarningThreshold()) {
                    logger.warn((Object)("Large row " + row.key.key + " in " + cfs.getColumnFamilyName() + " " + rowsize + " bytes"));
                }
                cfs.addToCompactedRowStats(rowsize);
            }
            validator.complete();
        }
        finally {
            ci.close();
        }
        SSTableReader ssTable = writer.closeAndOpenReader();
        cfs.replaceCompactedSSTables(sstables, Arrays.asList(ssTable));
        this.submitMinorIfNeeded(cfs);
        String format = "Compacted to %s.  %d/%d bytes for %d keys.  Time: %dms.";
        long dTime = System.currentTimeMillis() - startTime;
        logger.info((Object)String.format(format, writer.getFilename(), SSTable.getTotalBytes(sstables), ssTable.length(), totalkeysWritten, dTime));
        return sstables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SSTableReader> doAntiCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, Collection<Range> ranges, InetAddress target) throws IOException {
        Table table = cfs.getTable();
        logger.info((Object)("AntiCompacting [" + StringUtils.join(sstables, (String)",") + "]"));
        long expectedRangeFileSize = cfs.getExpectedCompactedFileSize(sstables) / 2L;
        String compactionFileLocation = table.getDataFileLocation(expectedRangeFileSize);
        if (compactionFileLocation == null) {
            throw new UnsupportedOperationException("disk full");
        }
        if (target != null) {
            compactionFileLocation = compactionFileLocation + File.separator + "stream";
        }
        ArrayList<SSTableReader> results = new ArrayList<SSTableReader>();
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        int expectedBloomFilterSize = Math.max(SSTableReader.indexInterval(), (int)(SSTableReader.getApproximateKeyCount(sstables) / 2L));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expected bloom filter size : " + expectedBloomFilterSize));
        }
        SSTableWriter writer = null;
        AntiCompactionIterator ci = new AntiCompactionIterator(sstables, ranges, CompactionManager.getDefaultGCBefore(), cfs.isCompleteSSTables(sstables));
        FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
        this.executor.beginCompaction(cfs, ci);
        try {
            if (!nni.hasNext()) {
                ArrayList<SSTableReader> arrayList = results;
                return arrayList;
            }
            while (nni.hasNext()) {
                CompactionIterator.CompactedRow row = (CompactionIterator.CompactedRow)nni.next();
                if (writer == null) {
                    FileUtils.createDirectory(compactionFileLocation);
                    String newFilename = new File(compactionFileLocation, cfs.getTempSSTableFileName()).getAbsolutePath();
                    writer = new SSTableWriter(newFilename, expectedBloomFilterSize, StorageService.getPartitioner());
                }
                writer.append(row.key, row.buffer);
                ++totalkeysWritten;
            }
        }
        finally {
            ci.close();
        }
        if (writer != null) {
            results.add(writer.closeAndOpenReader());
            String format = "AntiCompacted to %s.  %d/%d bytes for %d keys.  Time: %dms.";
            long dTime = System.currentTimeMillis() - startTime;
            logger.info((Object)String.format(format, writer.getFilename(), SSTable.getTotalBytes(sstables), ((SSTableReader)results.get(0)).length(), totalkeysWritten, dTime));
        }
        return results;
    }

    private void doCleanupCompaction(ColumnFamilyStore cfs) throws IOException {
        Collection<SSTableReader> originalSSTables = cfs.getSSTables();
        List<SSTableReader> sstables = this.doAntiCompaction(cfs, originalSSTables, StorageService.instance.getLocalRanges(cfs.getTable().name), null);
        if (!sstables.isEmpty()) {
            cfs.replaceCompactedSSTables(originalSSTables, sstables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadonlyCompaction(ColumnFamilyStore cfs, InetAddress initiator) throws IOException {
        Collection<SSTableReader> sstables = cfs.getSSTables();
        CompactionIterator ci = new CompactionIterator(sstables, CompactionManager.getDefaultGCBefore(), true);
        this.executor.beginCompaction(cfs, ci);
        try {
            FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
            AntiEntropyService.IValidator validator = AntiEntropyService.instance.getValidator(cfs.getTable().name, cfs.getColumnFamilyName(), initiator, true);
            validator.prepare();
            while (nni.hasNext()) {
                CompactionIterator.CompactedRow row = (CompactionIterator.CompactedRow)nni.next();
                validator.add(row);
            }
            validator.complete();
        }
        finally {
            ci.close();
        }
    }

    static Set<List<SSTableReader>> getBuckets(Iterable<SSTableReader> files, long min) {
        HashMap<List, Long> buckets = new HashMap<List, Long>();
        for (SSTableReader sstable : files) {
            long size = sstable.length();
            boolean bFound = false;
            for (Map.Entry entry : buckets.entrySet()) {
                List bucket = (List)entry.getKey();
                long averageSize = (Long)entry.getValue();
                if ((size <= averageSize / 2L || size >= 3L * averageSize / 2L) && (size >= min || averageSize >= min)) continue;
                buckets.remove(bucket);
                long totalSize = (long)bucket.size() * averageSize;
                averageSize = (totalSize + size) / (long)(bucket.size() + 1);
                bucket.add(sstable);
                buckets.put(bucket, averageSize);
                bFound = true;
                break;
            }
            if (bFound) continue;
            ArrayList<SSTableReader> bucket = new ArrayList<SSTableReader>();
            bucket.add(sstable);
            buckets.put(bucket, size);
        }
        return buckets.keySet();
    }

    public static int getDefaultGCBefore() {
        return (int)(System.currentTimeMillis() / 1000L) - DatabaseDescriptor.getGcGraceInSeconds();
    }

    public void checkAllColumnFamilies() throws IOException {
        for (final ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)("Estimating compactions for " + cfs.columnFamily_));
                    Set<List<SSTableReader>> buckets = CompactionManager.getBuckets(cfs.getSSTables(), 0x3200000L);
                    CompactionManager.this.updateEstimateFor(cfs, buckets);
                }
            };
            this.executor.submit(runnable);
        }
        for (final ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            this.submitMinorIfNeeded(cfs);
        }
    }

    @Override
    public String getColumnFamilyInProgress() {
        return this.executor.getColumnFamilyName();
    }

    @Override
    public Long getBytesTotalInProgress() {
        return this.executor.getBytesTotal();
    }

    @Override
    public Long getBytesCompacted() {
        return this.executor.getBytesCompleted();
    }

    @Override
    public int getPendingTasks() {
        int n = 0;
        for (Integer i : this.estimatedCompactions.values()) {
            n += i.intValue();
        }
        return n;
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class CompactionExecutor
    extends DebuggableThreadPoolExecutor {
        private volatile ColumnFamilyStore cfs;
        private volatile CompactionIterator ci;

        public CompactionExecutor() {
            super("COMPACTION-POOL");
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.cfs = null;
            this.ci = null;
        }

        void beginCompaction(ColumnFamilyStore cfs, CompactionIterator ci) {
            this.cfs = cfs;
            this.ci = ci;
        }

        public String getColumnFamilyName() {
            return this.cfs == null ? null : this.cfs.getColumnFamilyName();
        }

        public Long getBytesTotal() {
            return this.ci == null ? null : Long.valueOf(this.ci.getTotalBytes());
        }

        public Long getBytesCompleted() {
            return this.ci == null ? null : Long.valueOf(this.ci.getBytesRead());
        }
    }

    private static class AntiCompactionIterator
    extends CompactionIterator {
        private Set<SSTableScanner> scanners;

        public AntiCompactionIterator(Collection<SSTableReader> sstables, Collection<Range> ranges, int gcBefore, boolean isMajor) throws IOException {
            super(AntiCompactionIterator.getCollatedRangeIterator(sstables, ranges), gcBefore, isMajor);
        }

        private static Iterator getCollatedRangeIterator(Collection<SSTableReader> sstables, final Collection<Range> ranges) throws IOException {
            Predicate rangesPredicate = new Predicate(){

                public boolean evaluate(Object row) {
                    return Range.isTokenInRanges(((IteratingRow)row).getKey().token, ranges);
                }
            };
            CollatingIterator iter = FBUtilities.getCollatingIterator();
            for (SSTableReader sstable : sstables) {
                SSTableScanner scanner = sstable.getScanner(0x100000);
                iter.addIterator((Iterator)new FilterIterator((Iterator)scanner, rangesPredicate));
            }
            return iter;
        }

        @Override
        public Iterable<SSTableScanner> getScanners() {
            if (this.scanners == null) {
                this.scanners = new HashSet<SSTableScanner>();
                for (Object o : ((CollatingIterator)this.source).getIterators()) {
                    this.scanners.add((SSTableScanner)((FilterIterator)o).getIterator());
                }
            }
            return this.scanners;
        }
    }
}

