/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IFlushable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.AbstractColumnIterator;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class Memtable
implements Comparable<Memtable>,
IFlushable {
    private static final Logger logger = Logger.getLogger(Memtable.class);
    private boolean isFrozen;
    private final int THRESHOLD = DatabaseDescriptor.getMemtableThroughput() * 1024 * 1024;
    private final int THRESHOLD_COUNT = (int)(DatabaseDescriptor.getMemtableOperations() * 1024.0 * 1024.0);
    private final AtomicInteger currentThroughput = new AtomicInteger(0);
    private final AtomicInteger currentOperations = new AtomicInteger(0);
    private final long creationTime;
    private final ConcurrentNavigableMap<DecoratedKey, ColumnFamily> columnFamilies = new ConcurrentSkipListMap<DecoratedKey, ColumnFamily>();
    private final IPartitioner partitioner = StorageService.getPartitioner();
    private final ColumnFamilyStore cfs;

    public Memtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public int compareTo(Memtable rhs) {
        long diff = this.creationTime - rhs.creationTime;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public int getCurrentThroughput() {
        return this.currentThroughput.get();
    }

    public int getCurrentOperations() {
        return this.currentOperations.get();
    }

    boolean isThresholdViolated() {
        return this.currentThroughput.get() >= this.THRESHOLD || this.currentOperations.get() >= this.THRESHOLD_COUNT;
    }

    boolean isFrozen() {
        return this.isFrozen;
    }

    void freeze() {
        this.isFrozen = true;
    }

    void put(String key, ColumnFamily columnFamily) {
        assert (!this.isFrozen);
        this.resolve(key, columnFamily);
    }

    private void resolve(String key, ColumnFamily cf) {
        this.currentThroughput.addAndGet(cf.size());
        this.currentOperations.addAndGet(cf.getColumnCount());
        DecoratedKey decoratedKey = this.partitioner.decorateKey(key);
        ColumnFamily oldCf = this.columnFamilies.putIfAbsent(decoratedKey, cf);
        if (oldCf == null) {
            return;
        }
        oldCf.resolve(cf);
    }

    public String contents() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Map.Entry entry : this.columnFamilies.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    private SSTableReader writeSortedContents() throws IOException {
        logger.info((Object)("Writing " + this));
        SSTableWriter writer = new SSTableWriter(this.cfs.getFlushPath(), this.columnFamilies.size(), StorageService.getPartitioner());
        DataOutputBuffer buffer = new DataOutputBuffer();
        for (Map.Entry entry : this.columnFamilies.entrySet()) {
            buffer.reset();
            ColumnFamily.serializer().serializeWithIndexes((ColumnFamily)entry.getValue(), buffer);
            writer.append((DecoratedKey)entry.getKey(), buffer);
        }
        SSTableReader ssTable = writer.closeAndOpenReader();
        logger.info((Object)("Completed flushing " + ssTable.getFilename()));
        return ssTable;
    }

    @Override
    public void flushAndSignal(final Condition condition, ExecutorService sorter, ExecutorService writer) {
        this.cfs.getMemtablesPendingFlush().add(this);
        writer.submit(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws IOException {
                Memtable.this.cfs.addSSTable(Memtable.this.writeSortedContents());
                Memtable.this.cfs.getMemtablesPendingFlush().remove(Memtable.this);
                condition.signalAll();
            }
        });
    }

    public String toString() {
        return "Memtable(" + this.cfs.getColumnFamilyName() + ")@" + this.hashCode();
    }

    public Iterator<DecoratedKey> getKeyIterator(DecoratedKey startWith) {
        return this.columnFamilies.navigableKeySet().tailSet(startWith).iterator();
    }

    public boolean isClean() {
        return this.columnFamilies.isEmpty();
    }

    private String getTableName() {
        return this.cfs.getTable().name;
    }

    public ColumnIterator getSliceIterator(ColumnFamily cf, SliceQueryFilter filter, AbstractType typeComparator) {
        boolean isStandard;
        final ColumnFamily columnFamily = cf == null ? ColumnFamily.create(this.getTableName(), filter.getColumnFamilyName()) : cf.cloneMeShallow();
        Object[] columns = (cf == null ? columnFamily : cf).getSortedColumns().toArray(new IColumn[columnFamily.getSortedColumns().size()]);
        if (filter.reversed) {
            ArrayUtils.reverse((Object[])columns);
        }
        IColumn startIColumn = (isStandard = DatabaseDescriptor.getColumnFamilyType(this.getTableName(), filter.getColumnFamilyName()).equals("Standard")) ? new Column(filter.start) : new SuperColumn(filter.start, null);
        Comparator<IColumn> comparator = filter.getColumnComparator(typeComparator);
        int index = filter.start.length == 0 && filter.reversed ? 0 : Arrays.binarySearch(columns, startIColumn, comparator);
        final int startIndex = index < 0 ? -(index + 1) : index;
        return new AbstractColumnIterator((IColumn[])columns, isStandard){
            private int curIndex_;
            final /* synthetic */ IColumn[] val$columns;
            final /* synthetic */ boolean val$isStandard;
            {
                this.val$columns = iColumnArray;
                this.val$isStandard = bl;
                this.curIndex_ = startIndex;
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return columnFamily;
            }

            @Override
            public boolean hasNext() {
                return this.curIndex_ < this.val$columns.length;
            }

            @Override
            public IColumn next() {
                return this.val$isStandard ? this.val$columns[this.curIndex_++] : ((SuperColumn)this.val$columns[this.curIndex_++]).cloneMe();
            }
        };
    }

    public ColumnIterator getNamesIterator(final ColumnFamily cf, final NamesQueryFilter filter) {
        final ColumnFamily columnFamily = cf == null ? ColumnFamily.create(this.getTableName(), filter.getColumnFamilyName()) : cf.cloneMeShallow();
        final boolean isStandard = DatabaseDescriptor.getColumnFamilyType(this.getTableName(), filter.getColumnFamilyName()).equals("Standard");
        return new SimpleAbstractColumnIterator(){
            private Iterator<byte[]> iter;
            private byte[] current;
            {
                this.iter = filter.columns.iterator();
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return columnFamily;
            }

            protected IColumn computeNext() {
                if (cf == null) {
                    return (IColumn)this.endOfData();
                }
                while (this.iter.hasNext()) {
                    this.current = this.iter.next();
                    IColumn column = cf.getColumn(this.current);
                    if (column == null) continue;
                    return isStandard ? column : ((SuperColumn)column).cloneMe();
                }
                return (IColumn)this.endOfData();
            }
        };
    }

    public ColumnFamily getColumnFamily(String key) {
        return (ColumnFamily)this.columnFamilies.get(this.partitioner.decorateKey(key));
    }

    void clearUnsafe() {
        this.columnFamilies.clear();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.creationTime + (long)DatabaseDescriptor.getMemtableLifetimeMS();
    }
}

