/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutationSerializer;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class RowMutation {
    private static ICompactSerializer<RowMutation> serializer_ = new RowMutationSerializer();
    public static final String HINT = "HINT";
    private String table_;
    private String key_;
    protected Map<String, ColumnFamily> modifications_ = new HashMap<String, ColumnFamily>();

    public static ICompactSerializer<RowMutation> serializer() {
        return serializer_;
    }

    public RowMutation(String table, String key) {
        this.table_ = table;
        this.key_ = key;
    }

    public RowMutation(String table, Row row) {
        this.table_ = table;
        this.key_ = row.key;
        this.add(row.cf);
    }

    protected RowMutation(String table, String key, Map<String, ColumnFamily> modifications) {
        this.table_ = table;
        this.key_ = key;
        this.modifications_ = modifications;
    }

    public String getTable() {
        return this.table_;
    }

    public String key() {
        return this.key_;
    }

    public Set<String> columnFamilyNames() {
        return this.modifications_.keySet();
    }

    public Collection<ColumnFamily> getColumnFamilies() {
        return this.modifications_.values();
    }

    void addHints(String key, byte[] host) throws IOException {
        QueryPath path = new QueryPath("HintsColumnFamily", key.getBytes("UTF-8"), host);
        this.add(path, ArrayUtils.EMPTY_BYTE_ARRAY, System.currentTimeMillis());
    }

    public void add(ColumnFamily columnFamily) {
        assert (columnFamily != null);
        if (this.modifications_.containsKey(columnFamily.name())) {
            throw new IllegalArgumentException("ColumnFamily " + columnFamily.name() + " is already being modified");
        }
        this.modifications_.put(columnFamily.name(), columnFamily);
    }

    public void removeColumnFamily(ColumnFamily columnFamily) {
        this.modifications_.remove(columnFamily.name());
    }

    public boolean isEmpty() {
        return this.modifications_.isEmpty();
    }

    public void add(QueryPath path, byte[] value, long timestamp) {
        ColumnFamily columnFamily = this.modifications_.get(path.columnFamilyName);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
        }
        columnFamily.addColumn(path, value, timestamp);
        this.modifications_.put(path.columnFamilyName, columnFamily);
    }

    public void delete(QueryPath path, long timestamp) {
        assert (path.columnFamilyName != null);
        String cfName = path.columnFamilyName;
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily columnFamily = this.modifications_.get(cfName);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, cfName);
        }
        if (path.superColumnName == null && path.columnName == null) {
            columnFamily.delete(localDeleteTime, timestamp);
        } else if (path.columnName == null) {
            SuperColumn sc = new SuperColumn(path.superColumnName, DatabaseDescriptor.getSubComparator(this.table_, cfName));
            sc.markForDeleteAt(localDeleteTime, timestamp);
            columnFamily.addColumn(sc);
        } else {
            ByteBuffer bytes = ByteBuffer.allocate(4);
            bytes.putInt(localDeleteTime);
            columnFamily.addColumn(path, bytes.array(), timestamp, true);
        }
        this.modifications_.put(cfName, columnFamily);
    }

    public void apply() throws IOException {
        Table.open(this.table_).apply(this, this.getSerializedBuffer(), true);
    }

    void applyBinary() throws IOException, ExecutionException, InterruptedException {
        Table.open(this.table_).load(this);
    }

    public Message makeRowMutationMessage() throws IOException {
        return this.makeRowMutationMessage(StorageService.Verb.MUTATION);
    }

    public Message makeRowMutationMessage(StorageService.Verb verb) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        RowMutation.serializer().serialize(this, dos);
        return new Message(FBUtilities.getLocalAddress(), "ROW-MUTATION-STAGE", verb, bos.toByteArray());
    }

    public static RowMutation getRowMutationFromMutations(String keyspace, String key, Map<String, List<Mutation>> cfmap) {
        RowMutation rm = new RowMutation(keyspace, key.trim());
        for (Map.Entry<String, List<Mutation>> entry : cfmap.entrySet()) {
            String cfName = entry.getKey();
            for (Mutation mutation : entry.getValue()) {
                if (mutation.deletion != null) {
                    RowMutation.deleteColumnOrSuperColumnToRowMutation(rm, cfName, mutation.deletion);
                    continue;
                }
                RowMutation.addColumnOrSuperColumnToRowMutation(rm, cfName, mutation.column_or_supercolumn);
            }
        }
        return rm;
    }

    public static RowMutation getRowMutation(String table, String key, Map<String, List<ColumnOrSuperColumn>> cfmap) {
        RowMutation rm = new RowMutation(table, key.trim());
        for (Map.Entry<String, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
            String cfName = entry.getKey();
            for (ColumnOrSuperColumn cosc : entry.getValue()) {
                if (cosc.column == null) {
                    assert (cosc.super_column != null);
                    for (Column column : cosc.super_column.columns) {
                        rm.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp);
                    }
                    continue;
                }
                assert (cosc.super_column == null);
                rm.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp);
            }
        }
        return rm;
    }

    public DataOutputBuffer getSerializedBuffer() throws IOException {
        DataOutputBuffer buffer = new DataOutputBuffer();
        RowMutation.serializer().serialize(this, buffer);
        return buffer;
    }

    public String toString() {
        return "RowMutation(table='" + this.table_ + '\'' + ", key='" + this.key_ + '\'' + ", modifications=[" + StringUtils.join(this.modifications_.values(), (String)", ") + "]" + ')';
    }

    private static void addColumnOrSuperColumnToRowMutation(RowMutation rm, String cfName, ColumnOrSuperColumn cosc) {
        if (cosc.column == null) {
            for (Column column : cosc.super_column.columns) {
                rm.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp);
            }
        } else {
            rm.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp);
        }
    }

    private static void deleteColumnOrSuperColumnToRowMutation(RowMutation rm, String cfName, Deletion del) {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (byte[] c : del.predicate.column_names) {
                if (del.super_column == null && DatabaseDescriptor.getColumnFamilyType(rm.table_, cfName).equals("Super")) {
                    rm.delete(new QueryPath(cfName, c), del.timestamp);
                    continue;
                }
                rm.delete(new QueryPath(cfName, del.super_column, c), del.timestamp);
            }
        } else {
            rm.delete(new QueryPath(cfName, del.super_column), del.timestamp);
        }
    }
}

