/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class RowMutationVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(RowMutationVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        byte[] bytes = message.getMessageBody();
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        try {
            byte[] hintedBytes;
            RowMutation rm = RowMutation.serializer().deserialize(new DataInputStream(buffer));
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Applying " + rm));
            }
            if ((hintedBytes = message.getHeader("HINT")) != null) {
                assert (hintedBytes.length > 0);
                ByteBuffer bb = ByteBuffer.wrap(hintedBytes);
                byte[] addressBytes = new byte[FBUtilities.getLocalAddress().getAddress().length];
                while (bb.remaining() > 0) {
                    bb.get(addressBytes);
                    InetAddress hint = InetAddress.getByAddress(addressBytes);
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Adding hint for " + hint));
                    }
                    RowMutation hintedMutation = new RowMutation("system", rm.getTable());
                    hintedMutation.addHints(rm.key(), addressBytes);
                    hintedMutation.apply();
                }
            }
            Table.open(rm.getTable()).apply(rm, bytes, true);
            WriteResponse response = new WriteResponse(rm.getTable(), rm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)(rm + " applied.  Sending response to " + message.getMessageId() + "@" + message.getFrom()));
            }
            MessagingService.instance.sendOneWay(responseMessage, message.getFrom());
        }
        catch (IOException e) {
            logger_.error((Object)"Error in row mutation", (Throwable)e);
        }
    }
}

