/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.thrift.ColumnParent;

public class SliceByNamesReadCommand
extends ReadCommand {
    public final SortedSet<byte[]> columnNames = new TreeSet<byte[]>(this.getComparator());

    public SliceByNamesReadCommand(String table, String key, ColumnParent column_parent, Collection<byte[]> columnNames) {
        this(table, key, new QueryPath(column_parent), columnNames);
    }

    public SliceByNamesReadCommand(String table, String key, QueryPath path, Collection<byte[]> columnNames) {
        super(table, key, path, (byte)1);
        this.columnNames.addAll(columnNames);
    }

    @Override
    public ReadCommand copy() {
        SliceByNamesReadCommand readCommand = new SliceByNamesReadCommand(this.table, this.key, this.queryPath, this.columnNames);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public Row getRow(Table table) throws IOException {
        return table.getRow(new NamesQueryFilter(this.key, this.queryPath, this.columnNames));
    }

    public String toString() {
        return "SliceByNamesReadCommand(table='" + this.table + '\'' + ", key='" + this.key + '\'' + ", columnParent='" + this.queryPath + '\'' + ", columns=[" + this.getComparator().getString(this.columnNames) + "]" + ')';
    }
}

