/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOError;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.TreeSet;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class SystemTable {
    private static Logger logger = Logger.getLogger(SystemTable.class);
    public static final String STATUS_CF = "LocationInfo";
    private static final String LOCATION_KEY = "L";
    private static final String BOOTSTRAP_KEY = "Bootstrap";
    private static final byte[] BOOTSTRAP = SystemTable.utf8("B");
    private static final byte[] TOKEN = SystemTable.utf8("Token");
    private static final byte[] GENERATION = SystemTable.utf8("Generation");
    private static final byte[] CLUSTERNAME = SystemTable.utf8("ClusterName");
    private static StorageMetadata metadata;

    private static byte[] utf8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void updateToken(InetAddress ep, Token token) {
        IPartitioner p = StorageService.getPartitioner();
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(ep.getAddress(), p.getTokenFactory().toByteArray(token), System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static synchronized void updateToken(Token token) {
        assert (metadata != null);
        IPartitioner p = StorageService.getPartitioner();
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(TOKEN, p.getTokenFactory().toByteArray(token), System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        metadata.setToken(token);
    }

    public static synchronized StorageMetadata initMetadata() throws IOException {
        byte[] cname;
        if (metadata != null) {
            return metadata;
        }
        Table table = Table.open("system");
        TreeSet<byte[]> columns = new TreeSet<byte[]>(new BytesType());
        columns.add(TOKEN);
        columns.add(GENERATION);
        columns.add(CLUSTERNAME);
        NamesQueryFilter filter = new NamesQueryFilter(LOCATION_KEY, new QueryPath(STATUS_CF), columns);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        IPartitioner p = StorageService.getPartitioner();
        if (cf == null) {
            String initialToken = DatabaseDescriptor.getInitialToken();
            Object token = initialToken == null ? p.getRandomToken() : p.getTokenFactory().fromString(initialToken);
            logger.info((Object)("Saved Token not found. Using " + token));
            int generation = (int)(System.currentTimeMillis() / 1000L);
            logger.info((Object)("Saved ClusterName not found. Using " + DatabaseDescriptor.getClusterName()));
            RowMutation rm = new RowMutation("system", LOCATION_KEY);
            cf = ColumnFamily.create("system", STATUS_CF);
            cf.addColumn(new Column(TOKEN, p.getTokenFactory().toByteArray(token)));
            cf.addColumn(new Column(GENERATION, FBUtilities.toByteArray(generation)));
            cf.addColumn(new Column(CLUSTERNAME, DatabaseDescriptor.getClusterName().getBytes()));
            rm.add(cf);
            rm.apply();
            metadata = new StorageMetadata((Token)token, generation, DatabaseDescriptor.getClusterName().getBytes());
            return metadata;
        }
        if (cf.getColumnCount() < 2) {
            throw new RuntimeException("Expected both token and generation columns; found " + cf);
        }
        IColumn tokenColumn = cf.getColumn(TOKEN);
        assert (tokenColumn != null) : cf;
        Token token = p.getTokenFactory().fromByteArray(tokenColumn.value());
        logger.info((Object)("Saved Token found: " + token));
        IColumn generation = cf.getColumn(GENERATION);
        assert (generation != null) : cf;
        int gen = Math.max(FBUtilities.byteArrayToInt(generation.value()) + 1, (int)(System.currentTimeMillis() / 1000L));
        IColumn cluster = cf.getColumn(CLUSTERNAME);
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        cf = ColumnFamily.create("system", STATUS_CF);
        Column generation2 = new Column(GENERATION, FBUtilities.toByteArray(gen), generation.timestamp() + 1L);
        cf.addColumn(generation2);
        if (cluster != null) {
            logger.info((Object)("Saved ClusterName found: " + new String(cluster.value())));
            cname = cluster.value();
        } else {
            Column clustername = new Column(CLUSTERNAME, DatabaseDescriptor.getClusterName().getBytes());
            cf.addColumn(clustername);
            cname = DatabaseDescriptor.getClusterName().getBytes();
            logger.info((Object)("Saved ClusterName not found. Using " + DatabaseDescriptor.getClusterName()));
        }
        rm.add(cf);
        rm.apply();
        metadata = new StorageMetadata(token, gen, cname);
        return metadata;
    }

    public static boolean isBootstrapped() {
        Table table = null;
        try {
            table = Table.open("system");
            NamesQueryFilter filter = new NamesQueryFilter(BOOTSTRAP_KEY, new QueryPath(STATUS_CF), BOOTSTRAP);
            ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
            return cf != null && cf.getColumn(BOOTSTRAP).value()[0] == 1;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBootstrapped(boolean isBootstrapped) {
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(BOOTSTRAP, new byte[]{(byte)(isBootstrapped ? 1 : 0)}, System.currentTimeMillis()));
        RowMutation rm = new RowMutation("system", BOOTSTRAP_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class StorageMetadata {
        private Token token;
        private int generation;
        private byte[] cluster;

        StorageMetadata(Token storageId, int generation, byte[] clustername) {
            this.token = storageId;
            this.generation = generation;
            this.cluster = clustername;
        }

        public Token getToken() {
            return this.token;
        }

        public void setToken(Token storageId) {
            this.token = storageId;
        }

        public int getGeneration() {
            return this.generation;
        }

        public byte[] getClusterName() {
            return this.cluster;
        }
    }
}

