/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.db.filter.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class Table {
    public static final String SYSTEM_TABLE = "system";
    private static final Logger logger = Logger.getLogger(Table.class);
    private static final String SNAPSHOT_SUBDIR_NAME = "snapshots";
    static final ReentrantReadWriteLock flusherLock = new ReentrantReadWriteLock(true);
    private static Timer flushTimer = new Timer("FLUSH-TIMER");
    private final boolean waitForCommitLog;
    private static final Map<String, Table> instances;
    public final String name;
    private final TableMetadata tableMetadata;
    private final Map<String, ColumnFamilyStore> columnFamilyStores = new HashMap<String, ColumnFamilyStore>();
    private SortedSet<String> applicationColumnFamilies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Table open(String table) throws IOException {
        Table tableInstance = instances.get(table);
        if (tableInstance != null) return tableInstance;
        Class<Table> clazz = Table.class;
        synchronized (Table.class) {
            tableInstance = instances.get(table);
            if (tableInstance != null) return tableInstance;
            tableInstance = new Table(table);
            instances.put(table, tableInstance);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tableInstance;
        }
    }

    public Set<String> getColumnFamilies() {
        return this.tableMetadata.getColumnFamilies();
    }

    public Collection<ColumnFamilyStore> getColumnFamilyStores() {
        return Collections.unmodifiableCollection(this.columnFamilyStores.values());
    }

    public ColumnFamilyStore getColumnFamilyStore(String cfName) {
        return this.columnFamilyStores.get(cfName);
    }

    public void forceCleanup() {
        if (this.name.equals(SYSTEM_TABLE)) {
            throw new RuntimeException("Cleanup of the system table is neither necessary nor wise");
        }
        Set<String> columnFamilies = this.tableMetadata.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores.get(columnFamily);
            if (cfStore == null) continue;
            cfStore.forceCleanup();
        }
    }

    public void snapshot(String clientSuppliedName) throws IOException {
        String snapshotName = Long.toString(System.currentTimeMillis());
        if (clientSuppliedName != null && !clientSuppliedName.equals("")) {
            snapshotName = snapshotName + "-" + clientSuppliedName;
        }
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            cfStore.snapshot(snapshotName);
        }
    }

    public void clearSnapshot() throws IOException {
        for (String dataDirPath : DatabaseDescriptor.getAllDataFileLocations()) {
            String snapshotPath = dataDirPath + File.separator + this.name + File.separator + SNAPSHOT_SUBDIR_NAME;
            File snapshotDir = new File(snapshotPath);
            if (!snapshotDir.exists()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing snapshot directory " + snapshotPath));
            }
            FileUtils.deleteDir(snapshotDir);
        }
    }

    public List<SSTableReader> forceAntiCompaction(Collection<Range> ranges, InetAddress target) {
        ArrayList<SSTableReader> allResults = new ArrayList<SSTableReader>();
        Set<String> columnFamilies = this.tableMetadata.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores.get(columnFamily);
            try {
                allResults.addAll((Collection<SSTableReader>)CompactionManager.instance.submitAnticompaction(cfStore, ranges, target).get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return allResults;
    }

    public void forceCompaction() {
        Set<String> columnFamilies = this.tableMetadata.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores.get(columnFamily);
            if (cfStore == null) continue;
            CompactionManager.instance.submitMajor(cfStore);
        }
    }

    List<SSTableReader> getAllSSTablesOnDisk() {
        ArrayList<SSTableReader> list = new ArrayList<SSTableReader>();
        Set<String> columnFamilies = this.tableMetadata.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores.get(columnFamily);
            if (cfStore == null) continue;
            list.addAll(cfStore.getSSTables());
        }
        return list;
    }

    private Table(String table) throws IOException {
        this.name = table;
        this.waitForCommitLog = DatabaseDescriptor.getCommitLogSync() == DatabaseDescriptor.CommitLogSync.batch;
        this.tableMetadata = TableMetadata.instance(table);
        for (String columnFamily : this.tableMetadata.getColumnFamilies()) {
            this.columnFamilyStores.put(columnFamily, ColumnFamilyStore.createColumnFamilyStore(table, columnFamily));
        }
        int checkMs = DatabaseDescriptor.getMemtableLifetimeMS() / 10;
        flushTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (ColumnFamilyStore cfs : Table.this.columnFamilyStores.values()) {
                    try {
                        cfs.forceFlushIfExpired();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, checkMs, (long)checkMs);
    }

    public int getColumnFamilyId(String columnFamily) {
        return this.tableMetadata.getColumnFamilyId(columnFamily);
    }

    @Deprecated
    public ColumnFamily get(String key, String cfName) throws IOException {
        ColumnFamilyStore cfStore = this.columnFamilyStores.get(cfName);
        assert (cfStore != null) : "Column family " + cfName + " has not been defined";
        return cfStore.getColumnFamily(new IdentityQueryFilter(key, new QueryPath(cfName)));
    }

    public Row getRow(QueryFilter filter) throws IOException {
        ColumnFamilyStore cfStore = this.columnFamilyStores.get(filter.getColumnFamilyName());
        ColumnFamily columnFamily = cfStore.getColumnFamily(filter);
        return new Row(filter.key, columnFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(RowMutation mutation, Object serializedMutation, boolean writeCommitLog) throws IOException {
        HashMap<ColumnFamilyStore, Memtable> memtablesToFlush = new HashMap<ColumnFamilyStore, Memtable>(2);
        flusherLock.readLock().lock();
        try {
            if (writeCommitLog) {
                Future<CommitLogSegment.CommitLogContext> future = CommitLog.instance().add(mutation, serializedMutation);
                if (this.waitForCommitLog) {
                    try {
                        future.get();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
            for (ColumnFamily columnFamily : mutation.getColumnFamilies()) {
                ColumnFamily cachedRow;
                ColumnFamilyStore cfs = this.columnFamilyStores.get(columnFamily.name());
                Memtable memtableToFlush = cfs.apply(mutation.key(), columnFamily);
                if (memtableToFlush != null) {
                    memtablesToFlush.put(cfs, memtableToFlush);
                }
                if ((cachedRow = cfs.getRawCachedRow(mutation.key())) == null) continue;
                cachedRow.addAll(columnFamily);
            }
        }
        finally {
            flusherLock.readLock().unlock();
        }
        for (Map.Entry entry : memtablesToFlush.entrySet()) {
            ((ColumnFamilyStore)entry.getKey()).maybeSwitchMemtable((Memtable)entry.getValue(), writeCommitLog);
        }
    }

    public List<Future<?>> flush() throws IOException {
        ArrayList futures = new ArrayList();
        for (String cfName : this.columnFamilyStores.keySet()) {
            Object future = this.columnFamilyStores.get(cfName).forceFlush();
            if (future == null) continue;
            futures.add((Future<?>)future);
        }
        return futures;
    }

    void load(RowMutation rowMutation) throws IOException {
        String key = rowMutation.key();
        for (ColumnFamily columnFamily : rowMutation.getColumnFamilies()) {
            Collection<IColumn> columns = columnFamily.getSortedColumns();
            for (IColumn column : columns) {
                ColumnFamilyStore cfStore = this.columnFamilyStores.get(new String(column.name(), "UTF-8"));
                cfStore.applyBinary(key, column.value());
            }
        }
    }

    public String getDataFileLocation(long expectedCompactedFileSize) {
        String path = DatabaseDescriptor.getDataFileLocationForTable(this.name, expectedCompactedFileSize);
        if (path == null) {
            StorageService.instance.requestGC();
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            path = DatabaseDescriptor.getDataFileLocationForTable(this.name, expectedCompactedFileSize);
        }
        return path;
    }

    public static String getSnapshotPath(String dataDirPath, String tableName, String snapshotName) {
        return dataDirPath + File.separator + tableName + File.separator + SNAPSHOT_SUBDIR_NAME + File.separator + snapshotName;
    }

    public static Iterable<Table> all() {
        Function<String, Table> transformer = new Function<String, Table>(){

            public Table apply(String tableName) {
                try {
                    return Table.open(tableName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Iterables.transform(DatabaseDescriptor.getTables(), (Function)transformer);
    }

    static {
        try {
            DatabaseDescriptor.createAllDirectories();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        instances = new NonBlockingHashMap();
    }

    public static class TableMetadata {
        private static HashMap<String, TableMetadata> tableMetadataMap = new HashMap();
        private static Map<Integer, String> idCfMap_ = new HashMap<Integer, String>();
        private Map<String, String> cfTypeMap_ = new HashMap<String, String>();
        private Map<String, Integer> cfIdMap_ = new HashMap<String, Integer>();

        public static synchronized TableMetadata instance(String tableName) throws IOException {
            if (tableMetadataMap.get(tableName) == null) {
                tableMetadataMap.put(tableName, new TableMetadata());
            }
            return tableMetadataMap.get(tableName);
        }

        public void add(String cf, int id) {
            this.add(cf, id, "Standard");
        }

        public void add(String cf, int id, String type) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("adding " + cf + " as " + id));
            }
            assert (!idCfMap_.containsKey(id));
            this.cfIdMap_.put(cf, id);
            idCfMap_.put(id, cf);
            this.cfTypeMap_.put(cf, type);
        }

        public boolean isEmpty() {
            return this.cfIdMap_.isEmpty();
        }

        int getColumnFamilyId(String columnFamily) {
            return this.cfIdMap_.get(columnFamily);
        }

        public static String getColumnFamilyName(int id) {
            return idCfMap_.get(id);
        }

        String getColumnFamilyType(String cfName) {
            return this.cfTypeMap_.get(cfName);
        }

        Set<String> getColumnFamilies() {
            return this.cfIdMap_.keySet();
        }

        int size() {
            return this.cfIdMap_.size();
        }

        boolean isValidColumnFamily(String cfName) {
            return this.cfIdMap_.containsKey(cfName);
        }

        public String toString() {
            return "TableMetadata(" + FBUtilities.mapToString(this.cfIdMap_) + ")";
        }

        public static int getColumnFamilyCount() {
            return idCfMap_.size();
        }

        public static String getColumnFamilyIDString() {
            return FBUtilities.mapToString(tableMetadataMap);
        }

        static {
            try {
                DatabaseDescriptor.storeMetadata();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

