/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.FBUtilities;

public class WriteResponse {
    private static WriteResponseSerializer serializer_ = new WriteResponseSerializer();
    private final String table_;
    private final String key_;
    private final boolean status_;

    public static WriteResponseSerializer serializer() {
        return serializer_;
    }

    public static Message makeWriteResponseMessage(Message original, WriteResponse writeResponseMessage) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        WriteResponse.serializer().serialize(writeResponseMessage, dos);
        return original.getReply(FBUtilities.getLocalAddress(), bos.toByteArray());
    }

    public WriteResponse(String table, String key, boolean bVal) {
        this.table_ = table;
        this.key_ = key;
        this.status_ = bVal;
    }

    public String table() {
        return this.table_;
    }

    public String key() {
        return this.key_;
    }

    public boolean isSuccess() {
        return this.status_;
    }

    public static class WriteResponseSerializer
    implements ICompactSerializer<WriteResponse> {
        @Override
        public void serialize(WriteResponse wm, DataOutputStream dos) throws IOException {
            dos.writeUTF(wm.table());
            dos.writeUTF(wm.key());
            dos.writeBoolean(wm.isSuccess());
        }

        @Override
        public WriteResponse deserialize(DataInputStream dis) throws IOException {
            String table = dis.readUTF();
            String key = dis.readUTF();
            boolean status = dis.readBoolean();
            return new WriteResponse(table, key, status);
        }
    }
}

