/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogExecutorServiceMBean;
import org.apache.cassandra.utils.WrappedRunnable;

class CommitLogExecutorService
extends AbstractExecutorService
implements CommitLogExecutorServiceMBean {
    private final BlockingQueue<CheaterFutureTask> queue;
    private volatile long completedTaskCount = 0L;
    private final ArrayList<CheaterFutureTask> incompleteTasks = new ArrayList();
    private final ArrayList taskValues = new ArrayList();

    public CommitLogExecutorService() {
        this(DatabaseDescriptor.getCommitLogSync() == DatabaseDescriptor.CommitLogSync.batch ? DatabaseDescriptor.getConcurrentWriters() : 1024 * Runtime.getRuntime().availableProcessors());
    }

    public CommitLogExecutorService(int queueSize) {
        this.queue = new LinkedBlockingQueue<CheaterFutureTask>(queueSize);
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                if (DatabaseDescriptor.getCommitLogSync() == DatabaseDescriptor.CommitLogSync.batch) {
                    while (true) {
                        CommitLogExecutorService.this.processWithSyncBatch();
                        CommitLogExecutorService.this.completedTaskCount++;
                    }
                }
                while (true) {
                    CommitLogExecutorService.this.process();
                    CommitLogExecutorService.this.completedTaskCount++;
                }
            }
        };
        new Thread((Runnable)runnable, "COMMIT-LOG-WRITER").start();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.db:type=Commitlog"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getActiveCount() {
        return 1;
    }

    @Override
    public long getCompletedTasks() {
        return this.completedTaskCount;
    }

    @Override
    public long getPendingTasks() {
        return this.queue.size();
    }

    private void process() throws InterruptedException {
        this.queue.take().run();
    }

    private void processWithSyncBatch() throws Exception {
        CheaterFutureTask firstTask = this.queue.take();
        if (!(firstTask.getRawCallable() instanceof CommitLog.LogRecordAdder)) {
            firstTask.run();
            return;
        }
        this.incompleteTasks.clear();
        this.taskValues.clear();
        long end = System.nanoTime() + (long)(1000000.0 * DatabaseDescriptor.getCommitLogSyncBatchWindow());
        this.incompleteTasks.add(firstTask);
        this.taskValues.add(firstTask.getRawCallable().call());
        while (!this.queue.isEmpty() && ((CheaterFutureTask)this.queue.peek()).getRawCallable() instanceof CommitLog.LogRecordAdder && System.nanoTime() < end) {
            CheaterFutureTask task = (CheaterFutureTask)this.queue.remove();
            this.incompleteTasks.add(task);
            this.taskValues.add(task.getRawCallable().call());
        }
        try {
            CommitLog.instance().sync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.incompleteTasks.size(); ++i) {
            this.incompleteTasks.get(i).set(this.taskValues.get(i));
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newTaskFor(Executors.callable(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new CheaterFutureTask<T>(callable);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.queue.put((CheaterFutureTask)command);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    private static class CheaterFutureTask<V>
    extends FutureTask<V> {
        private final Callable rawCallable;

        public CheaterFutureTask(Callable<V> callable) {
            super(callable);
            this.rawCallable = callable;
        }

        public Callable getRawCallable() {
            return this.rawCallable;
        }

        @Override
        public void set(V v) {
            super.set(v);
        }
    }
}

