/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.utils.BitSetSerializer;

class CommitLogHeader {
    private static CommitLogHeaderSerializer serializer = new CommitLogHeaderSerializer();
    private BitSet dirty;
    private int[] lastFlushedAt;

    static CommitLogHeaderSerializer serializer() {
        return serializer;
    }

    static int getLowestPosition(CommitLogHeader clHeader) {
        int minPosition = Integer.MAX_VALUE;
        for (int position : clHeader.lastFlushedAt) {
            if (position >= minPosition || position <= 0) continue;
            minPosition = position;
        }
        if (minPosition == Integer.MAX_VALUE) {
            minPosition = 0;
        }
        return minPosition;
    }

    CommitLogHeader(int size) {
        this.dirty = new BitSet(size);
        this.lastFlushedAt = new int[size];
    }

    CommitLogHeader(BitSet dirty, int[] lastFlushedAt) {
        this.dirty = dirty;
        this.lastFlushedAt = lastFlushedAt;
    }

    boolean isDirty(int index) {
        return this.dirty.get(index);
    }

    int getPosition(int index) {
        return this.lastFlushedAt[index];
    }

    void turnOn(int index, long position) {
        this.dirty.set(index);
        this.lastFlushedAt[index] = (int)position;
    }

    void turnOff(int index) {
        this.dirty.set(index, false);
        this.lastFlushedAt[index] = 0;
    }

    boolean isSafeToDelete() throws IOException {
        return this.dirty.isEmpty();
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        CommitLogHeader.serializer().serialize(this, dos);
        return bos.toByteArray();
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("");
        sb.append("CLH(dirty={");
        for (i = 0; i < this.dirty.size(); ++i) {
            if (!this.dirty.get(i)) continue;
            sb.append(Table.TableMetadata.getColumnFamilyName(i)).append(", ");
        }
        sb.append("}, flushed={");
        for (i = 0; i < this.lastFlushedAt.length; ++i) {
            sb.append(Table.TableMetadata.getColumnFamilyName(i)).append(": ").append(this.lastFlushedAt[i]).append(", ");
        }
        sb.append("})");
        return sb.toString();
    }

    public String dirtyString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.dirty.length(); ++i) {
            if (!this.dirty.get(i)) continue;
            sb.append(i).append(", ");
        }
        return sb.toString();
    }

    static CommitLogHeader readCommitLogHeader(BufferedRandomAccessFile logReader) throws IOException {
        int size = (int)logReader.readLong();
        byte[] bytes = new byte[size];
        logReader.read(bytes);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        return CommitLogHeader.serializer().deserialize(new DataInputStream(byteStream));
    }

    public int getColumnFamilyCount() {
        return this.lastFlushedAt.length;
    }

    static class CommitLogHeaderSerializer
    implements ICompactSerializer<CommitLogHeader> {
        CommitLogHeaderSerializer() {
        }

        @Override
        public void serialize(CommitLogHeader clHeader, DataOutputStream dos) throws IOException {
            BitSetSerializer.serialize(clHeader.dirty, dos);
            dos.writeInt(clHeader.lastFlushedAt.length);
            for (int position : clHeader.lastFlushedAt) {
                dos.writeInt(position);
            }
        }

        @Override
        public CommitLogHeader deserialize(DataInputStream dis) throws IOException {
            BitSet bitFlags = BitSetSerializer.deserialize(dis);
            int[] position = new int[dis.readInt()];
            for (int i = 0; i < position.length; ++i) {
                position[i] = dis.readInt();
            }
            return new CommitLogHeader(bitFlags, position);
        }
    }
}

