/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLogHeader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.log4j.Logger;

public class CommitLogSegment {
    private static final Logger logger = Logger.getLogger(CommitLogSegment.class);
    private final BufferedRandomAccessFile logWriter;
    private final CommitLogHeader header;

    public CommitLogSegment(int cfCount) {
        this.header = new CommitLogHeader(cfCount);
        String logFile = DatabaseDescriptor.getLogFileLocation() + File.separator + "CommitLog-" + System.currentTimeMillis() + ".log";
        logger.info((Object)("Creating new commitlog segment " + logFile));
        try {
            this.logWriter = CommitLogSegment.createWriter(logFile);
            this.writeCommitLogHeader(this.header.toByteArray());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void writeHeader() throws IOException {
        this.seekAndWriteCommitLogHeader(this.header.toByteArray());
    }

    void seekAndWriteCommitLogHeader(byte[] bytes) throws IOException {
        long currentPos = this.logWriter.getFilePointer();
        this.logWriter.seek(0L);
        this.writeCommitLogHeader(bytes);
        this.logWriter.seek(currentPos);
    }

    private void writeCommitLogHeader(byte[] bytes) throws IOException {
        this.logWriter.writeLong(bytes.length);
        this.logWriter.write(bytes);
        this.logWriter.sync();
    }

    private static BufferedRandomAccessFile createWriter(String file) throws IOException {
        return new BufferedRandomAccessFile(file, "rw", 131072);
    }

    public CommitLogContext write(RowMutation rowMutation, Object serializedRow) throws IOException {
        long currentPosition = -1L;
        try {
            currentPosition = this.logWriter.getFilePointer();
            CommitLogContext cLogCtx = new CommitLogContext(currentPosition);
            Table table = Table.open(rowMutation.getTable());
            for (ColumnFamily columnFamily : rowMutation.getColumnFamilies()) {
                int id = table.getColumnFamilyId(columnFamily.name());
                if (this.header.isDirty(id)) continue;
                this.header.turnOn(id, this.logWriter.getFilePointer());
                this.seekAndWriteCommitLogHeader(this.header.toByteArray());
            }
            CRC32 checkum = new CRC32();
            if (serializedRow instanceof DataOutputBuffer) {
                DataOutputBuffer buffer = (DataOutputBuffer)serializedRow;
                this.logWriter.writeLong(buffer.getLength());
                this.logWriter.write(buffer.getData(), 0, buffer.getLength());
                checkum.update(buffer.getData(), 0, buffer.getLength());
            } else {
                assert (serializedRow instanceof byte[]);
                byte[] bytes = (byte[])serializedRow;
                this.logWriter.writeLong(bytes.length);
                this.logWriter.write(bytes);
                checkum.update(bytes, 0, bytes.length);
            }
            this.logWriter.writeLong(checkum.getValue());
            return cLogCtx;
        }
        catch (IOException e) {
            if (currentPosition != -1L) {
                this.logWriter.seek(currentPosition);
            }
            throw e;
        }
    }

    public void sync() throws IOException {
        this.logWriter.sync();
    }

    public CommitLogContext getContext() {
        return new CommitLogContext(this.logWriter.getFilePointer());
    }

    public CommitLogHeader getHeader() {
        return this.header;
    }

    public String getPath() {
        return this.logWriter.getPath();
    }

    public long length() {
        try {
            return this.logWriter.length();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void close() {
        try {
            this.logWriter.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public String toString() {
        return "CommitLogSegment(" + this.logWriter.getPath() + ')';
    }

    public class CommitLogContext {
        public final long position;

        public CommitLogContext(long position) {
            assert (position >= 0L);
            this.position = position;
        }

        public CommitLogSegment getSegment() {
            return CommitLogSegment.this;
        }

        public String toString() {
            return "CommitLogContext(file='" + CommitLogSegment.this.logWriter.getPath() + '\'' + ", position=" + this.position + ')';
        }
    }
}

