/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.utils.ReducingIterator;

public abstract class QueryFilter {
    public final String key;
    public final QueryPath path;

    protected QueryFilter(String key, QueryPath path) {
        this.key = key;
        this.path = path;
    }

    public abstract ColumnIterator getMemColumnIterator(Memtable var1, ColumnFamily var2, AbstractType var3);

    public ColumnIterator getMemColumnIterator(Memtable memtable, AbstractType comparator) {
        return this.getMemColumnIterator(memtable, memtable.getColumnFamily(this.key), comparator);
    }

    public abstract ColumnIterator getSSTableColumnIterator(SSTableReader var1) throws IOException;

    public abstract void collectReducedColumns(IColumnContainer var1, Iterator<IColumn> var2, int var3);

    public abstract SuperColumn filterSuperColumn(SuperColumn var1, int var2);

    public Comparator<IColumn> getColumnComparator(final AbstractType comparator) {
        return new Comparator<IColumn>(){

            @Override
            public int compare(IColumn c1, IColumn c2) {
                return comparator.compare(c1.name(), c2.name());
            }
        };
    }

    public void collectCollatedColumns(final ColumnFamily returnCF, Iterator<IColumn> collatedColumns, int gcBefore) {
        ReducingIterator<IColumn, IColumn> reduced = new ReducingIterator<IColumn, IColumn>(collatedColumns){
            ColumnFamily curCF;
            {
                super(x0);
                this.curCF = returnCF.cloneMeShallow();
            }

            @Override
            protected boolean isEqual(IColumn o1, IColumn o2) {
                return Arrays.equals(o1.name(), o2.name());
            }

            @Override
            public void reduce(IColumn current) {
                this.curCF.addColumn(current);
            }

            @Override
            protected IColumn getReduced() {
                IColumn c = this.curCF.getSortedColumns().iterator().next();
                this.curCF.clear();
                return c;
            }
        };
        this.collectReducedColumns(returnCF, (Iterator<IColumn>)reduced, gcBefore);
    }

    public String getColumnFamilyName() {
        return this.path.columnFamilyName;
    }

    public static boolean isRelevant(IColumn column, IColumnContainer container, int gcBefore) {
        long maxChange = column.mostRecentLiveChangeAt();
        return !(column.isMarkedForDelete() && column.getLocalDeletionTime() <= gcBefore && maxChange <= column.getMarkedForDeleteAt() || container.isMarkedForDelete() && maxChange <= container.getMarkedForDeleteAt());
    }
}

