/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.commons.lang.ArrayUtils;

public class QueryPath {
    public final String columnFamilyName;
    public final byte[] superColumnName;
    public final byte[] columnName;

    public QueryPath(String columnFamilyName, byte[] superColumnName, byte[] columnName) {
        this.columnFamilyName = columnFamilyName;
        this.superColumnName = superColumnName;
        this.columnName = columnName;
    }

    public QueryPath(ColumnParent columnParent) {
        this(columnParent.column_family, columnParent.super_column, null);
    }

    public QueryPath(String columnFamilyName, byte[] superColumnName) {
        this(columnFamilyName, superColumnName, null);
    }

    public QueryPath(String columnFamilyName) {
        this(columnFamilyName, null);
    }

    public QueryPath(ColumnPath column_path) {
        this(column_path.column_family, column_path.super_column, column_path.column);
    }

    public static QueryPath column(byte[] columnName) {
        return new QueryPath(null, null, columnName);
    }

    public String toString() {
        return "QueryPath(columnFamilyName='" + this.columnFamilyName + '\'' + ", superColumnName='" + this.superColumnName + '\'' + ", columnName='" + this.columnName + '\'' + ')';
    }

    public void serialize(DataOutputStream dos) throws IOException {
        assert (!"".equals(this.columnFamilyName));
        assert (this.superColumnName == null || this.superColumnName.length > 0);
        assert (this.columnName == null || this.columnName.length > 0);
        dos.writeUTF(this.columnFamilyName == null ? "" : this.columnFamilyName);
        ColumnSerializer.writeName(this.superColumnName == null ? ArrayUtils.EMPTY_BYTE_ARRAY : this.superColumnName, dos);
        ColumnSerializer.writeName(this.columnName == null ? ArrayUtils.EMPTY_BYTE_ARRAY : this.columnName, dos);
    }

    public static QueryPath deserialize(DataInputStream din) throws IOException {
        String cfName = din.readUTF();
        byte[] scName = ColumnSerializer.readName(din);
        byte[] cName = ColumnSerializer.readName(din);
        return new QueryPath(cfName.isEmpty() ? null : cfName, scName.length == 0 ? null : scName, cName.length == 0 ? null : cName);
    }
}

