/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IndexHelper;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;

class SSTableSliceIterator
extends AbstractIterator<IColumn>
implements ColumnIterator {
    private final boolean reversed;
    private final byte[] startColumn;
    private final byte[] finishColumn;
    private final AbstractType comparator;
    private ColumnGroupReader reader;

    public SSTableSliceIterator(SSTableReader ssTable, String key, byte[] startColumn, byte[] finishColumn, boolean reversed) throws IOException {
        this.reversed = reversed;
        DecoratedKey decoratedKey = ssTable.getPartitioner().decorateKey(key);
        FileDataInput fdi = ssTable.getFileDataInput(decoratedKey, DatabaseDescriptor.getSlicedReadBufferSizeInKB() * 1024);
        this.comparator = ssTable.getColumnComparator();
        this.startColumn = startColumn;
        this.finishColumn = finishColumn;
        if (fdi != null) {
            this.reader = new ColumnGroupReader(ssTable, decoratedKey, fdi);
        }
    }

    private boolean isColumnNeeded(IColumn column) {
        if (this.startColumn.length == 0 && this.finishColumn.length == 0) {
            return true;
        }
        if (this.startColumn.length == 0 && !this.reversed) {
            return this.comparator.compare(column.name(), this.finishColumn) <= 0;
        }
        if (this.startColumn.length == 0 && this.reversed) {
            return this.comparator.compare(column.name(), this.finishColumn) >= 0;
        }
        if (this.finishColumn.length == 0 && !this.reversed) {
            return this.comparator.compare(column.name(), this.startColumn) >= 0;
        }
        if (this.finishColumn.length == 0 && this.reversed) {
            return this.comparator.compare(column.name(), this.startColumn) <= 0;
        }
        if (!this.reversed) {
            return this.comparator.compare(column.name(), this.startColumn) >= 0 && this.comparator.compare(column.name(), this.finishColumn) <= 0;
        }
        return this.comparator.compare(column.name(), this.startColumn) <= 0 && this.comparator.compare(column.name(), this.finishColumn) >= 0;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.reader.getEmptyColumnFamily();
    }

    protected IColumn computeNext() {
        IColumn column;
        if (this.reader == null) {
            return (IColumn)this.endOfData();
        }
        do {
            if ((column = this.reader.pollColumn()) != null) continue;
            return (IColumn)this.endOfData();
        } while (!this.isColumnNeeded(column));
        return column;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    class ColumnGroupReader {
        private final ColumnFamily emptyColumnFamily;
        private final List<IndexHelper.IndexInfo> indexes;
        private final FileDataInput file;
        private int curRangeIndex;
        private Deque<IColumn> blockColumns = new ArrayDeque<IColumn>();

        public ColumnGroupReader(SSTableReader ssTable, DecoratedKey key, FileDataInput input) throws IOException {
            this.file = input;
            DecoratedKey keyInDisk = ssTable.getPartitioner().convertFromDiskFormat(this.file.readUTF());
            assert (keyInDisk.equals(key)) : String.format("%s != %s in %s", keyInDisk, key, this.file.getPath());
            this.file.readInt();
            IndexHelper.skipBloomFilter(this.file);
            this.indexes = IndexHelper.deserializeIndex(this.file);
            this.emptyColumnFamily = ColumnFamily.serializer().deserializeFromSSTableNoColumns(ssTable.makeColumnFamily(), this.file);
            this.file.readInt();
            this.file.mark();
            this.curRangeIndex = IndexHelper.indexFor(SSTableSliceIterator.this.startColumn, this.indexes, SSTableSliceIterator.this.comparator, SSTableSliceIterator.this.reversed);
            if (SSTableSliceIterator.this.reversed && this.curRangeIndex == this.indexes.size()) {
                --this.curRangeIndex;
            }
        }

        public ColumnFamily getEmptyColumnFamily() {
            return this.emptyColumnFamily;
        }

        public IColumn pollColumn() {
            IColumn column = this.blockColumns.poll();
            if (column == null) {
                try {
                    if (this.getNextBlock()) {
                        column = this.blockColumns.poll();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return column;
        }

        public boolean getNextBlock() throws IOException {
            if (this.curRangeIndex < 0 || this.curRangeIndex >= this.indexes.size()) {
                return false;
            }
            IndexHelper.IndexInfo curColPosition = this.indexes.get(this.curRangeIndex);
            if (SSTableSliceIterator.this.reversed ? SSTableSliceIterator.this.finishColumn.length > 0 && SSTableSliceIterator.this.comparator.compare(SSTableSliceIterator.this.finishColumn, curColPosition.lastName) > 0 || SSTableSliceIterator.this.startColumn.length > 0 && SSTableSliceIterator.this.comparator.compare(SSTableSliceIterator.this.startColumn, curColPosition.firstName) < 0 : SSTableSliceIterator.this.startColumn.length > 0 && SSTableSliceIterator.this.comparator.compare(SSTableSliceIterator.this.startColumn, curColPosition.lastName) > 0 || SSTableSliceIterator.this.finishColumn.length > 0 && SSTableSliceIterator.this.comparator.compare(SSTableSliceIterator.this.finishColumn, curColPosition.firstName) < 0) {
                return false;
            }
            boolean outOfBounds = false;
            this.file.reset();
            long curOffset = this.file.skipBytes((int)curColPosition.offset);
            assert (curOffset == curColPosition.offset);
            while ((long)this.file.bytesPastMark() < curColPosition.offset + curColPosition.width && !outOfBounds) {
                IColumn column = this.emptyColumnFamily.getColumnSerializer().deserialize(this.file);
                if (SSTableSliceIterator.this.reversed) {
                    this.blockColumns.addFirst(column);
                } else {
                    this.blockColumns.addLast(column);
                }
                if (!SSTableSliceIterator.this.reversed && SSTableSliceIterator.this.finishColumn.length > 0) {
                    outOfBounds = SSTableSliceIterator.this.comparator.compare(column.name(), SSTableSliceIterator.this.finishColumn) >= 0;
                } else if (SSTableSliceIterator.this.reversed && SSTableSliceIterator.this.startColumn.length > 0) {
                    boolean bl = outOfBounds = SSTableSliceIterator.this.comparator.compare(column.name(), SSTableSliceIterator.this.startColumn) >= 0;
                }
                if (!outOfBounds) continue;
                break;
            }
            this.curRangeIndex = SSTableSliceIterator.this.reversed ? --this.curRangeIndex : ++this.curRangeIndex;
            return true;
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

