/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.util.Collection;
import java.util.Comparator;
import org.apache.cassandra.db.IColumn;

public abstract class AbstractType
implements Comparator<byte[]> {
    public abstract String getString(byte[] var1);

    public void validate(byte[] bytes) {
        this.getString(bytes);
    }

    public Comparator<byte[]> getReverseComparator() {
        return new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length == 0) {
                    return o2.length == 0 ? 0 : -1;
                }
                if (o2.length == 0) {
                    return 1;
                }
                return -AbstractType.this.compare(o1, o2);
            }
        };
    }

    public String getString(Collection<byte[]> names) {
        StringBuilder builder = new StringBuilder();
        for (byte[] name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public String getColumnsString(Collection<IColumn> columns) {
        StringBuilder builder = new StringBuilder();
        for (IColumn column : columns) {
            builder.append(column.getString(this)).append(",");
        }
        return builder.toString();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().getName().equals(this.getClass().getName());
    }
}

