/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.ICompactSerializer2;

public abstract class AbstractBounds
implements Serializable {
    private static AbstractBoundsSerializer serializer = new AbstractBoundsSerializer();
    public final Token left;
    public final Token right;
    protected final transient IPartitioner partitioner;

    public static ICompactSerializer2<AbstractBounds> serializer() {
        return serializer;
    }

    public AbstractBounds(Token left, Token right, IPartitioner partitioner) {
        this.left = left;
        this.right = right;
        this.partitioner = partitioner;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract boolean equals(Object var1);

    public abstract boolean contains(Token var1);

    public abstract Set<AbstractBounds> restrictTo(Range var1);

    public abstract List<AbstractBounds> unwrap();

    private static class AbstractBoundsSerializer
    implements ICompactSerializer2<AbstractBounds> {
        private AbstractBoundsSerializer() {
        }

        @Override
        public void serialize(AbstractBounds range, DataOutput out) throws IOException {
            out.writeInt(range instanceof Range ? Type.RANGE.ordinal() : Type.BOUNDS.ordinal());
            Token.serializer().serialize(range.left, out);
            Token.serializer().serialize(range.right, out);
        }

        @Override
        public AbstractBounds deserialize(DataInput in) throws IOException {
            if (in.readInt() == Type.RANGE.ordinal()) {
                return new Range(Token.serializer().deserialize(in), Token.serializer().deserialize(in));
            }
            return new Bounds(Token.serializer().deserialize(in), Token.serializer().deserialize(in));
        }
    }

    private static enum Type {
        RANGE,
        BOUNDS;

    }
}

