/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.StreamIn;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BootStrapper {
    private static final Logger logger = Logger.getLogger(BootStrapper.class);
    protected final InetAddress address;
    protected final Token token;
    protected final TokenMetadata tokenMetadata;

    public BootStrapper(InetAddress address, Token token, TokenMetadata tmd) {
        assert (address != null);
        assert (token != null);
        this.address = address;
        this.token = token;
        this.tokenMetadata = tmd;
    }

    public void startBootstrap() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Beginning bootstrap process");
        }
        for (String table : DatabaseDescriptor.getNonSystemTables()) {
            Multimap<Range, InetAddress> rangesWithSourceTarget = this.getRangesWithSources(table);
            for (Map.Entry entry : BootStrapper.getWorkMap(rangesWithSourceTarget).asMap().entrySet()) {
                InetAddress source = (InetAddress)entry.getKey();
                StorageService.instance.addBootstrapSource(source, table);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Requesting from " + source + " ranges " + StringUtils.join((Collection)((Collection)entry.getValue()), (String)", ")));
                }
                StreamIn.requestRanges(source, table, (Collection)entry.getValue());
            }
        }
    }

    public static Token getBootstrapToken(TokenMetadata metadata, Map<InetAddress, Double> load) throws IOException {
        if (DatabaseDescriptor.getInitialToken() != null) {
            logger.debug((Object)("token manually specified as " + DatabaseDescriptor.getInitialToken()));
            return StorageService.getPartitioner().getTokenFactory().fromString(DatabaseDescriptor.getInitialToken());
        }
        return BootStrapper.getBalancedToken(metadata, load);
    }

    public static Token getBalancedToken(TokenMetadata metadata, Map<InetAddress, Double> load) {
        InetAddress maxEndpoint = BootStrapper.getBootstrapSource(metadata, load);
        Token<?> t = BootStrapper.getBootstrapTokenFrom(maxEndpoint);
        logger.info((Object)("New token will be " + t + " to assume load from " + maxEndpoint));
        return t;
    }

    static InetAddress getBootstrapSource(final TokenMetadata metadata, final Map<InetAddress, Double> load) {
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(load.size());
        for (InetAddress endpoint : load.keySet()) {
            if (!metadata.isMember(endpoint)) continue;
            endpoints.add(endpoint);
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No other nodes seen!  Unable to bootstrap");
        }
        Collections.sort(endpoints, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress ia1, InetAddress ia2) {
                double load2;
                int n2;
                int n1 = metadata.pendingRangeChanges(ia1);
                if (n1 != (n2 = metadata.pendingRangeChanges(ia2))) {
                    return -(n1 - n2);
                }
                double load1 = (Double)load.get(ia1);
                if (load1 == (load2 = ((Double)load.get(ia2)).doubleValue())) {
                    return 0;
                }
                return load1 < load2 ? -1 : 1;
            }
        });
        InetAddress maxEndpoint = (InetAddress)endpoints.get(endpoints.size() - 1);
        assert (!maxEndpoint.equals(FBUtilities.getLocalAddress()));
        return maxEndpoint;
    }

    Multimap<Range, InetAddress> getRangesWithSources(String table) {
        assert (this.tokenMetadata.sortedTokens().size() > 0);
        AbstractReplicationStrategy strat = StorageService.instance.getReplicationStrategy(table);
        Collection<Range> myRanges = strat.getPendingAddressRanges(this.tokenMetadata, this.token, this.address, table);
        ArrayListMultimap myRangeAddresses = ArrayListMultimap.create();
        Multimap<Range, InetAddress> rangeAddresses = strat.getRangeAddresses(this.tokenMetadata, table);
        for (Range myRange : myRanges) {
            for (Range range : rangeAddresses.keySet()) {
                if (!range.contains(myRange)) continue;
                List<InetAddress> preferred = DatabaseDescriptor.getEndPointSnitch(table).getSortedListByProximity(this.address, rangeAddresses.get((Object)range));
                myRangeAddresses.putAll((Object)myRange, preferred);
                break;
            }
            assert (myRangeAddresses.keySet().contains(myRange));
        }
        return myRangeAddresses;
    }

    private static Token<?> getBootstrapTokenFrom(InetAddress maxEndpoint) {
        Message message = new Message(FBUtilities.getLocalAddress(), "", StorageService.Verb.BOOTSTRAP_TOKEN, ArrayUtils.EMPTY_BYTE_ARRAY);
        BootstrapTokenCallback btc = new BootstrapTokenCallback();
        MessagingService.instance.sendRR(message, maxEndpoint, (IAsyncCallback)btc);
        return btc.getToken();
    }

    static Multimap<InetAddress, Range> getWorkMap(Multimap<Range, InetAddress> rangesWithSourceTarget) {
        return BootStrapper.getWorkMap(rangesWithSourceTarget, FailureDetector.instance);
    }

    static Multimap<InetAddress, Range> getWorkMap(Multimap<Range, InetAddress> rangesWithSourceTarget, IFailureDetector failureDetector) {
        ArrayListMultimap sources = ArrayListMultimap.create();
        block0: for (Range range : rangesWithSourceTarget.keySet()) {
            for (InetAddress source : rangesWithSourceTarget.get((Object)range)) {
                if (!failureDetector.isAlive(source)) continue;
                sources.put((Object)source, (Object)range);
                continue block0;
            }
        }
        return sources;
    }

    private static class BootstrapTokenCallback
    implements IAsyncCallback {
        private volatile Token<?> token;
        private final Condition condition = new SimpleCondition();

        private BootstrapTokenCallback() {
        }

        public Token<?> getToken() {
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.token;
        }

        @Override
        public void response(Message msg) {
            try {
                this.token = StorageService.getPartitioner().getTokenFactory().fromString(new String(msg.getMessageBody(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError();
            }
            this.condition.signalAll();
        }
    }

    public static class BootstrapTokenVerbHandler
    implements IVerbHandler {
        @Override
        public void doVerb(Message message) {
            Message response;
            StorageService ss = StorageService.instance;
            String tokenString = ss.getBootstrapToken().toString();
            try {
                response = message.getReply(FBUtilities.getLocalAddress(), tokenString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError();
            }
            MessagingService.instance.sendOneWay(response, message.getFrom());
        }
    }
}

