/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;

public class Bounds
extends AbstractBounds {
    public Bounds(Token left, Token right) {
        this(left, right, StorageService.getPartitioner());
    }

    Bounds(Token left, Token right, IPartitioner partitioner) {
        super(left, right, partitioner);
        assert (left.compareTo(right) <= 0 || right.equals(partitioner.getMinimumToken())) : "[" + left + "," + right + "]";
    }

    @Override
    public boolean contains(Token token) {
        return Range.contains(this.left, this.right, token) || this.left.equals(token);
    }

    @Override
    public Set<AbstractBounds> restrictTo(Range range) {
        Object min = this.partitioner.getMinimumToken();
        if (this.left.equals(this.right) && !this.right.equals(min)) {
            return range.contains(this.left) ? Collections.unmodifiableSet(new HashSet<Bounds>(Arrays.asList(this))) : Collections.emptySet();
        }
        Set<AbstractBounds> ranges = range.intersectionWith(new Range(this.left, this.right));
        if (!range.contains(this.left)) {
            return ranges;
        }
        HashSet<AbstractBounds> S = new HashSet<AbstractBounds>(ranges.size());
        for (Range range2 : ranges) {
            if (range2.left.equals(this.left)) {
                S.add(new Bounds(range2.left, range2.right));
                continue;
            }
            S.add(range2);
        }
        return Collections.unmodifiableSet(S);
    }

    @Override
    public List<AbstractBounds> unwrap() {
        return Arrays.asList(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Bounds)) {
            return false;
        }
        Bounds rhs = (Bounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "[" + this.left + "," + this.right + "]";
    }
}

