/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.ArrayUtils;

public class CollatingOrderPreservingPartitioner
implements IPartitioner<BytesToken> {
    static final Collator collator = Collator.getInstance(new Locale("en", "US"));
    public static final BytesToken MINIMUM = new BytesToken(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final BigInteger BYTE_MASK = new BigInteger("255");
    private final Token.TokenFactory<byte[]> tokenFactory = new Token.TokenFactory<byte[]>(){

        @Override
        public byte[] toByteArray(Token<byte[]> bytesToken) {
            return (byte[])bytesToken.token;
        }

        @Override
        public Token<byte[]> fromByteArray(byte[] bytes) {
            return new BytesToken(bytes);
        }

        @Override
        public String toString(Token<byte[]> bytesToken) {
            return FBUtilities.bytesToHex((byte[])bytesToken.token);
        }

        @Override
        public Token<byte[]> fromString(String string) {
            return new BytesToken(FBUtilities.hexToBytes(string));
        }
    };

    @Override
    public DecoratedKey<BytesToken> decorateKey(String key) {
        return new DecoratedKey<BytesToken>(this.getToken(key), key);
    }

    @Override
    public DecoratedKey<BytesToken> convertFromDiskFormat(String key) {
        return new DecoratedKey<BytesToken>(this.getToken(key), key);
    }

    @Override
    public String convertToDiskFormat(DecoratedKey<BytesToken> key) {
        return key.key;
    }

    @Override
    public BytesToken midpoint(BytesToken ltoken, BytesToken rtoken) {
        int sigbytes = Math.max(((byte[])ltoken.token).length, ((byte[])rtoken.token).length);
        BigInteger left = this.bigForBytes((byte[])ltoken.token, sigbytes);
        BigInteger right = this.bigForBytes((byte[])rtoken.token, sigbytes);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 8 * sigbytes);
        return new BytesToken(this.bytesForBig((BigInteger)midpair.left, sigbytes, (Boolean)midpair.right));
    }

    private BigInteger bigForBytes(byte[] bytes, int sigbytes) {
        if (bytes.length != sigbytes) {
            bytes = Arrays.copyOf(bytes, sigbytes);
        }
        return new BigInteger(1, bytes);
    }

    private byte[] bytesForBig(BigInteger big, int sigbytes, boolean remainder) {
        byte[] bytes = new byte[sigbytes + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigbytes;
            bytes[n] = (byte)(bytes[n] | 0x80);
        }
        for (int i = 0; i < sigbytes; ++i) {
            int maskpos = 8 * (sigbytes - (i + 1));
            bytes[i] = (byte)(big.and(BYTE_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFF);
        }
        return bytes;
    }

    @Override
    public BytesToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BytesToken getRandomToken() {
        Random r = new Random();
        byte[] buffer = new byte[16];
        r.nextBytes(buffer);
        return new BytesToken(buffer);
    }

    @Override
    public Token.TokenFactory<byte[]> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public BytesToken getToken(String key) {
        if (key.isEmpty()) {
            return MINIMUM;
        }
        return new BytesToken(collator.getCollationKey(key).toByteArray());
    }
}

