/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.GuidGenerator;
import org.apache.cassandra.utils.Pair;

public class RandomPartitioner
implements IPartitioner<BigIntegerToken> {
    public static final BigInteger TWO = new BigInteger("2");
    public static final BigIntegerToken MINIMUM = new BigIntegerToken("0");
    private static final String DELIMITER = ":";
    private final Token.TokenFactory<BigInteger> tokenFactory = new Token.TokenFactory<BigInteger>(){

        @Override
        public byte[] toByteArray(Token<BigInteger> bigIntegerToken) {
            return ((BigInteger)bigIntegerToken.token).toByteArray();
        }

        @Override
        public Token<BigInteger> fromByteArray(byte[] bytes) {
            return new BigIntegerToken(new BigInteger(bytes));
        }

        @Override
        public String toString(Token<BigInteger> bigIntegerToken) {
            return ((BigInteger)bigIntegerToken.token).toString();
        }

        @Override
        public Token<BigInteger> fromString(String string) {
            return new BigIntegerToken(new BigInteger(string));
        }
    };

    @Override
    public DecoratedKey<BigIntegerToken> decorateKey(String key) {
        return new DecoratedKey<BigIntegerToken>(this.getToken(key), key);
    }

    @Override
    public DecoratedKey<BigIntegerToken> convertFromDiskFormat(String key) {
        int splitPoint = key.indexOf(DELIMITER);
        String first = key.substring(0, splitPoint);
        String second = key.substring(splitPoint + 1);
        return new DecoratedKey<BigIntegerToken>(new BigIntegerToken(first), second);
    }

    @Override
    public String convertToDiskFormat(DecoratedKey<BigIntegerToken> key) {
        return key.token + DELIMITER + key.key;
    }

    @Override
    public BigIntegerToken midpoint(BigIntegerToken ltoken, BigIntegerToken rtoken) {
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint((BigInteger)ltoken.token, (BigInteger)rtoken.token, 127);
        return new BigIntegerToken((BigInteger)midpair.left);
    }

    @Override
    public BigIntegerToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BigIntegerToken getRandomToken() {
        String guid = GuidGenerator.guid();
        BigInteger token = FBUtilities.hash(guid);
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    @Override
    public Token.TokenFactory<BigInteger> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public BigIntegerToken getToken(String key) {
        if (key.isEmpty()) {
            return MINIMUM;
        }
        return new BigIntegerToken(FBUtilities.hash(key));
    }
}

