/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.lang.ObjectUtils;

public class Range
extends AbstractBounds
implements Comparable<Range>,
Serializable {
    public static final long serialVersionUID = 1L;

    public Range(Token left, Token right) {
        this(left, right, StorageService.getPartitioner());
    }

    public Range(Token left, Token right, IPartitioner partitioner) {
        super(left, right, partitioner);
    }

    public static boolean contains(Token left, Token right, Token bi) {
        if (Range.isWrapAround(left, right)) {
            if (bi.compareTo(left) > 0) {
                return true;
            }
            return right.compareTo(bi) >= 0;
        }
        return bi.compareTo(left) > 0 && right.compareTo(bi) >= 0;
    }

    public boolean contains(Range that) {
        boolean thatwraps;
        if (this.left.equals(this.right)) {
            return true;
        }
        boolean thiswraps = Range.isWrapAround(this.left, this.right);
        if (thiswraps == (thatwraps = Range.isWrapAround(that.left, that.right))) {
            return this.left.compareTo(that.left) <= 0 && that.right.compareTo(this.right) <= 0;
        }
        if (thiswraps) {
            return this.left.compareTo(that.left) <= 0 || that.right.compareTo(this.right) <= 0;
        }
        return false;
    }

    @Override
    public boolean contains(Token bi) {
        return Range.contains(this.left, this.right, bi);
    }

    public boolean intersects(Range that) {
        return this.intersectionWith(that).size() > 0;
    }

    public static Set<Range> rangeSet(Range ... ranges) {
        return Collections.unmodifiableSet(new HashSet<Range>(Arrays.asList(ranges)));
    }

    public Set<Range> intersectionWith(Range that) {
        if (this.contains(that)) {
            return Range.rangeSet(that);
        }
        if (that.contains(this)) {
            return Range.rangeSet(this);
        }
        boolean thiswraps = Range.isWrapAround(this.left, this.right);
        boolean thatwraps = Range.isWrapAround(that.left, that.right);
        if (!thiswraps && !thatwraps) {
            if (this.left.compareTo(that.right) >= 0 || that.left.compareTo(this.right) >= 0) {
                return Collections.emptySet();
            }
            return Range.rangeSet(new Range((Token)ObjectUtils.max((Comparable)this.left, (Comparable)that.left), (Token)ObjectUtils.min((Comparable)this.right, (Comparable)that.right)));
        }
        if (thiswraps && thatwraps) {
            assert (!this.left.equals(that.left));
            return this.left.compareTo(that.left) < 0 ? Range.intersectionBothWrapping(this, that) : Range.intersectionBothWrapping(that, this);
        }
        if (thiswraps && !thatwraps) {
            return Range.intersectionOneWrapping(this, that);
        }
        assert (!thiswraps && thatwraps);
        return Range.intersectionOneWrapping(that, this);
    }

    private static Set<Range> intersectionBothWrapping(Range first, Range that) {
        HashSet<Range> intersection = new HashSet<Range>(2);
        if (that.right.compareTo(first.left) > 0) {
            intersection.add(new Range(first.left, that.right));
        }
        intersection.add(new Range(that.left, first.right));
        return Collections.unmodifiableSet(intersection);
    }

    private static Set<Range> intersectionOneWrapping(Range wrapping, Range other) {
        HashSet<Range> intersection = new HashSet<Range>(2);
        if (other.contains(wrapping.right)) {
            intersection.add(new Range(other.left, wrapping.right));
        }
        if (other.contains(wrapping.left) && wrapping.left.compareTo(other.right) < 0) {
            intersection.add(new Range(wrapping.left, other.right));
        }
        return Collections.unmodifiableSet(intersection);
    }

    @Override
    public Set<AbstractBounds> restrictTo(Range range) {
        return this.intersectionWith(range);
    }

    @Override
    public List<AbstractBounds> unwrap() {
        if (!this.isWrapAround() || this.right.equals(this.partitioner.getMinimumToken())) {
            return Arrays.asList(this);
        }
        ArrayList<AbstractBounds> unwrapped = new ArrayList<AbstractBounds>(2);
        unwrapped.add(new Range(this.left, (Token)this.partitioner.getMinimumToken()));
        unwrapped.add(new Range((Token)this.partitioner.getMinimumToken(), this.right));
        return unwrapped;
    }

    public static boolean isWrapAround(Token left, Token right) {
        return left.compareTo(right) >= 0;
    }

    @Override
    public int compareTo(Range rhs) {
        if (Range.isWrapAround(this.left, this.right)) {
            return -1;
        }
        if (Range.isWrapAround(rhs.left, rhs.right)) {
            return 1;
        }
        return this.right.compareTo(rhs.right);
    }

    public static boolean isTokenInRanges(Token token, Iterable<Range> ranges) {
        assert (ranges != null);
        for (Range range : ranges) {
            if (!range.contains(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        Range rhs = (Range)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "(" + this.left + "," + this.right + "]";
    }

    public boolean isWrapAround() {
        return Range.isWrapAround(this.left, this.right);
    }
}

