/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointStateSerializer;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.io.ICompactSerializer;

public class EndPointState {
    private static ICompactSerializer<EndPointState> serializer_ = new EndPointStateSerializer();
    HeartBeatState hbState_;
    Map<String, ApplicationState> applicationState_ = new Hashtable<String, ApplicationState>();
    long updateTimestamp_;
    boolean isAlive_;
    boolean isAGossiper_;
    boolean hasToken_;

    public static ICompactSerializer<EndPointState> serializer() {
        return serializer_;
    }

    EndPointState(HeartBeatState hbState) {
        this.hbState_ = hbState;
        this.updateTimestamp_ = System.currentTimeMillis();
        this.isAlive_ = true;
        this.isAGossiper_ = false;
        this.hasToken_ = false;
    }

    HeartBeatState getHeartBeatState() {
        return this.hbState_;
    }

    synchronized void setHeartBeatState(HeartBeatState hbState) {
        this.updateTimestamp();
        this.hbState_ = hbState;
    }

    public ApplicationState getApplicationState(String key) {
        return this.applicationState_.get(key);
    }

    public Map<String, ApplicationState> getApplicationStateMap() {
        return this.applicationState_;
    }

    void addApplicationState(String key, ApplicationState appState) {
        this.applicationState_.put(key, appState);
    }

    long getUpdateTimestamp() {
        return this.updateTimestamp_;
    }

    synchronized void updateTimestamp() {
        this.updateTimestamp_ = System.currentTimeMillis();
    }

    public boolean isAlive() {
        return this.isAlive_;
    }

    synchronized void isAlive(boolean value) {
        this.isAlive_ = value;
    }

    boolean isAGossiper() {
        return this.isAGossiper_;
    }

    synchronized void isAGossiper(boolean value) {
        this.isAGossiper_ = value;
    }

    public synchronized void setHasToken(boolean value) {
        this.hasToken_ = value;
    }

    public boolean getHasToken() {
        return this.hasToken_;
    }

    public List<Map.Entry<String, ApplicationState>> getSortedApplicationStates() {
        ArrayList<Map.Entry<String, ApplicationState>> entries = new ArrayList<Map.Entry<String, ApplicationState>>();
        entries.addAll(this.applicationState_.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, ApplicationState>>(){

            @Override
            public int compare(Map.Entry<String, ApplicationState> lhs, Map.Entry<String, ApplicationState> rhs) {
                return lhs.getValue().compareTo(rhs.getValue());
            }
        });
        return entries;
    }
}

