/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.net.CompactEndPointSerializationHelper;
import org.apache.log4j.Logger;

class EndPointStatesSerializationHelper {
    private static final Logger logger_ = Logger.getLogger(EndPointStatesSerializationHelper.class);

    EndPointStatesSerializationHelper() {
    }

    static boolean serialize(Map<InetAddress, EndPointState> epStateMap, DataOutputStream dos) throws IOException {
        boolean bVal = true;
        int estimate = 0;
        int size = epStateMap.size();
        dos.writeInt(size);
        for (Map.Entry<InetAddress, EndPointState> entry : epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            if (1428 - dos.size() < estimate) {
                logger_.info((Object)("@@@@ Breaking out to respect the MTU size in EPS. Estimate is " + estimate + " @@@@"));
                bVal = false;
                break;
            }
            int pre = dos.size();
            CompactEndPointSerializationHelper.serialize(ep, dos);
            EndPointState.serializer().serialize(entry.getValue(), dos);
            int post = dos.size();
            estimate = post - pre;
        }
        return bVal;
    }

    static Map<InetAddress, EndPointState> deserialize(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        HashMap<InetAddress, EndPointState> epStateMap = new HashMap<InetAddress, EndPointState>();
        for (int i = 0; i < size; ++i) {
            if (dis.available() == 0) {
                logger_.info((Object)"Remaining bytes zero. Stopping deserialization in EndPointState.");
                break;
            }
            InetAddress ep = CompactEndPointSerializationHelper.deserialize(dis);
            EndPointState epState = EndPointState.serializer().deserialize(dis);
            epStateMap.put(ep, epState);
        }
        return epStateMap;
    }
}

