/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.gms.ArrivalWindow;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class FailureDetector
implements IFailureDetector,
FailureDetectorMBean {
    public static final IFailureDetector instance = new FailureDetector();
    private static Logger logger_ = Logger.getLogger(FailureDetector.class);
    private static final int sampleSize_ = 1000;
    private static final int phiConvictThreshold_ = 8;
    private static final long uptimeThreshold_ = 60000L;
    private static long creationTime_;
    private Map<InetAddress, ArrivalWindow> arrivalSamples_ = new Hashtable<InetAddress, ArrivalWindow>();
    private List<IFailureDetectionEventListener> fdEvntListeners_ = new ArrayList<IFailureDetectionEventListener>();

    public FailureDetector() {
        creationTime_ = System.currentTimeMillis();
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.gms:type=FailureDetector"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dumpInterArrivalTimes() {
        try {
            FileOutputStream fos = new FileOutputStream("/var/tmp/output-" + System.currentTimeMillis() + ".dat", true);
            fos.write(this.toString().getBytes());
            fos.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void dumpInterArrivalTimes(InetAddress ep) {
        long now = System.currentTimeMillis();
        if (now - creationTime_ <= 60000L) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream("/var/tmp/output-" + System.currentTimeMillis() + "-" + ep + ".dat", true);
            ArrivalWindow hWnd = this.arrivalSamples_.get(ep);
            fos.write(hWnd.toString().getBytes());
            fos.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public boolean isAlive(InetAddress ep) {
        InetAddress localHost = FBUtilities.getLocalAddress();
        if (localHost.equals(ep)) {
            return true;
        }
        EndPointState epState = Gossiper.instance.getEndPointStateForEndPoint(ep);
        return epState.isAlive();
    }

    @Override
    public void report(InetAddress ep) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("reporting " + ep));
        }
        long now = System.currentTimeMillis();
        ArrivalWindow heartbeatWindow = this.arrivalSamples_.get(ep);
        if (heartbeatWindow == null) {
            heartbeatWindow = new ArrivalWindow(1000);
            this.arrivalSamples_.put(ep, heartbeatWindow);
        }
        heartbeatWindow.add(now);
    }

    @Override
    public void interpret(InetAddress ep) {
        ArrivalWindow hbWnd = this.arrivalSamples_.get(ep);
        if (hbWnd == null) {
            return;
        }
        long now = System.currentTimeMillis();
        double phi = hbWnd.phi(now);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("PHI for " + ep + " : " + phi));
        }
        if (phi > 8.0) {
            for (IFailureDetectionEventListener listener : this.fdEvntListeners_) {
                listener.convict(ep);
            }
        }
    }

    @Override
    public void remove(InetAddress ep) {
        this.arrivalSamples_.remove(ep);
    }

    @Override
    public void registerFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners_.add(listener);
    }

    @Override
    public void unregisterFailureDetectionEventListener(IFailureDetectionEventListener listener) {
        this.fdEvntListeners_.remove(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<InetAddress> eps = this.arrivalSamples_.keySet();
        sb.append("-----------------------------------------------------------------------");
        for (InetAddress ep : eps) {
            ArrivalWindow hWnd = this.arrivalSamples_.get(ep);
            sb.append(ep + " : ");
            sb.append(hWnd.toString());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("-----------------------------------------------------------------------");
        return sb.toString();
    }

    public static void main(String[] args) throws Throwable {
    }
}

