/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSynMessage;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.IEndPointStateChangePublisher;
import org.apache.cassandra.gms.IEndPointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.JoinMessage;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;

public class Gossiper
implements IFailureDetectionEventListener,
IEndPointStateChangePublisher {
    static final int MAX_GOSSIP_PACKET_SIZE = 1428;
    public static final int intervalInMillis_ = 1000;
    private static Logger logger_ = Logger.getLogger(Gossiper.class);
    public static final Gossiper instance = new Gossiper();
    private Timer gossipTimer_;
    private InetAddress localEndPoint_;
    private long aVeryLongTime_ = 259200000L;
    private long FatClientTimeout_ = 3600000L;
    private Random random_ = new Random();
    private List<IEndPointStateChangeSubscriber> subscribers_ = new ArrayList<IEndPointStateChangeSubscriber>();
    private Set<InetAddress> liveEndpoints_ = new HashSet<InetAddress>();
    private Set<InetAddress> unreachableEndpoints_ = new HashSet<InetAddress>();
    private Set<InetAddress> seeds_ = new HashSet<InetAddress>();
    Map<InetAddress, EndPointState> endPointStateMap_ = new Hashtable<InetAddress, EndPointState>();
    Map<InetAddress, Long> justRemovedEndPoints_ = new Hashtable<InetAddress, Long>();

    private Gossiper() {
        this.gossipTimer_ = new Timer(false);
        FailureDetector.instance.registerFailureDetectionEventListener(this);
    }

    @Override
    public synchronized void register(IEndPointStateChangeSubscriber subscriber) {
        this.subscribers_.add(subscriber);
    }

    @Override
    public synchronized void unregister(IEndPointStateChangeSubscriber subscriber) {
        this.subscribers_.remove(subscriber);
    }

    public Set<InetAddress> getLiveMembers() {
        HashSet<InetAddress> liveMbrs = new HashSet<InetAddress>(this.liveEndpoints_);
        liveMbrs.add(this.localEndPoint_);
        return liveMbrs;
    }

    public Set<InetAddress> getUnreachableMembers() {
        return new HashSet<InetAddress>(this.unreachableEndpoints_);
    }

    @Override
    public void convict(InetAddress endpoint) {
        EndPointState epState = this.endPointStateMap_.get(endpoint);
        if (epState.isAlive()) {
            logger_.info((Object)("InetAddress " + endpoint + " is now dead."));
            this.isAlive(endpoint, epState, false);
        }
    }

    int getMaxEndPointStateVersion(EndPointState epState) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        versions.add(epState.getHeartBeatState().getHeartBeatVersion());
        Map<String, ApplicationState> appStateMap = epState.getApplicationStateMap();
        for (ApplicationState value : appStateMap.values()) {
            int stateVersion = value.getStateVersion();
            versions.add(stateVersion);
        }
        Collections.sort(versions);
        int maxVersion = (Integer)versions.get(versions.size() - 1);
        versions.clear();
        return maxVersion;
    }

    void evictFromMembership(InetAddress endpoint) {
        this.unreachableEndpoints_.remove(endpoint);
    }

    public void removeEndPoint(InetAddress endpoint) {
        this.liveEndpoints_.remove(endpoint);
        this.unreachableEndpoints_.remove(endpoint);
        this.endPointStateMap_.remove(endpoint);
        FailureDetector.instance.remove(endpoint);
        this.justRemovedEndPoints_.put(endpoint, System.currentTimeMillis());
    }

    void makeRandomGossipDigest(List<GossipDigest> gDigests) {
        EndPointState epState = this.endPointStateMap_.get(this.localEndPoint_);
        int generation = epState.getHeartBeatState().getGeneration();
        int maxVersion = this.getMaxEndPointStateVersion(epState);
        gDigests.add(new GossipDigest(this.localEndPoint_, generation, maxVersion));
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(this.endPointStateMap_.keySet());
        Collections.shuffle(endpoints, this.random_);
        for (InetAddress endPoint : endpoints) {
            epState = this.endPointStateMap_.get(endPoint);
            if (epState != null) {
                generation = epState.getHeartBeatState().getGeneration();
                maxVersion = this.getMaxEndPointStateVersion(epState);
                gDigests.add(new GossipDigest(endPoint, generation, maxVersion));
                continue;
            }
            gDigests.add(new GossipDigest(endPoint, 0, 0));
        }
        StringBuilder sb = new StringBuilder();
        for (GossipDigest gDigest : gDigests) {
            sb.append(gDigest);
            sb.append(" ");
        }
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Gossip Digests are : " + sb.toString()));
        }
    }

    public boolean isKnownEndpoint(InetAddress endpoint) {
        return this.endPointStateMap_.containsKey(endpoint);
    }

    public int getCurrentGenerationNumber(InetAddress endpoint) {
        return this.endPointStateMap_.get(endpoint).getHeartBeatState().getGeneration();
    }

    Message makeGossipDigestSynMessage(List<GossipDigest> gDigests) throws IOException {
        GossipDigestSynMessage gDigestMessage = new GossipDigestSynMessage(DatabaseDescriptor.getClusterName(), gDigests);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1428);
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestSynMessage.serializer().serialize(gDigestMessage, dos);
        return new Message(this.localEndPoint_, "GS", StorageService.Verb.GOSSIP_DIGEST_SYN, bos.toByteArray());
    }

    Message makeGossipDigestAckMessage(GossipDigestAckMessage gDigestAckMessage) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1428);
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAckMessage.serializer().serialize(gDigestAckMessage, dos);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("@@@@ Size of GossipDigestAckMessage is " + bos.toByteArray().length));
        }
        return new Message(this.localEndPoint_, "GS", StorageService.Verb.GOSSIP_DIGEST_ACK, bos.toByteArray());
    }

    Message makeGossipDigestAck2Message(GossipDigestAck2Message gDigestAck2Message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1428);
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAck2Message.serializer().serialize(gDigestAck2Message, dos);
        return new Message(this.localEndPoint_, "GS", StorageService.Verb.GOSSIP_DIGEST_ACK2, bos.toByteArray());
    }

    boolean sendGossip(Message message, Set<InetAddress> epSet) {
        int size = epSet.size();
        ArrayList<InetAddress> liveEndPoints = new ArrayList<InetAddress>(epSet);
        int index = size == 1 ? 0 : this.random_.nextInt(size);
        InetAddress to = (InetAddress)liveEndPoints.get(index);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Sending a GossipDigestSynMessage to " + to + " ..."));
        }
        MessagingService.instance.sendOneWay(message, to);
        return this.seeds_.contains(to);
    }

    boolean doGossipToLiveMember(Message message) {
        int size = this.liveEndpoints_.size();
        if (size == 0) {
            return false;
        }
        return this.sendGossip(message, this.liveEndpoints_);
    }

    void doGossipToUnreachableMember(Message message) {
        double liveEndPoints = this.liveEndpoints_.size();
        double unreachableEndPoints = this.unreachableEndpoints_.size();
        if (unreachableEndPoints > 0.0) {
            double prob = unreachableEndPoints / (liveEndPoints + 1.0);
            double randDbl = this.random_.nextDouble();
            if (randDbl < prob) {
                this.sendGossip(message, this.unreachableEndpoints_);
            }
        }
    }

    void doGossipToSeed(Message message) {
        int size = this.seeds_.size();
        if (size > 0) {
            if (size == 1 && this.seeds_.contains(this.localEndPoint_)) {
                return;
            }
            if (this.liveEndpoints_.size() == 0) {
                this.sendGossip(message, this.seeds_);
            } else {
                double probability = (double)this.seeds_.size() / (double)(this.liveEndpoints_.size() + this.unreachableEndpoints_.size());
                double randDbl = this.random_.nextDouble();
                if (randDbl <= probability) {
                    this.sendGossip(message, this.seeds_);
                }
            }
        }
    }

    void doStatusCheck() {
        long now = System.currentTimeMillis();
        Set<InetAddress> eps = this.endPointStateMap_.keySet();
        for (InetAddress endpoint : eps) {
            if (endpoint.equals(this.localEndPoint_)) continue;
            FailureDetector.instance.interpret(endpoint);
            EndPointState epState = this.endPointStateMap_.get(endpoint);
            if (epState != null) {
                long duration = now - epState.getUpdateTimestamp();
                if (!epState.getHasToken() && !epState.isAlive() && duration > this.FatClientTimeout_) {
                    if (StorageService.instance.getTokenMetadata().isMember(endpoint)) {
                        epState.setHasToken(true);
                    } else {
                        logger_.info((Object)("FatClient " + endpoint + " has been silent for " + this.FatClientTimeout_ + "ms, removing from gossip"));
                        this.removeEndPoint(endpoint);
                    }
                }
                if (!epState.isAlive() && duration > this.aVeryLongTime_) {
                    this.evictFromMembership(endpoint);
                }
            }
            if (this.justRemovedEndPoints_.isEmpty()) continue;
            Hashtable<InetAddress, Long> copy = new Hashtable<InetAddress, Long>(this.justRemovedEndPoints_);
            for (Map.Entry<InetAddress, Long> entry : copy.entrySet()) {
                if (now - entry.getValue() <= 30000L) continue;
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("30000 elapsed, " + entry.getKey() + " gossip quarantine over"));
                }
                this.justRemovedEndPoints_.remove(entry.getKey());
            }
        }
    }

    EndPointState getEndPointStateForEndPoint(InetAddress ep) {
        return this.endPointStateMap_.get(ep);
    }

    synchronized EndPointState getStateForVersionBiggerThan(InetAddress forEndpoint, int version) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Scanning for state greater than " + version + " for " + forEndpoint));
        }
        EndPointState epState = this.endPointStateMap_.get(forEndpoint);
        EndPointState reqdEndPointState = null;
        if (epState != null) {
            int localHbVersion = epState.getHeartBeatState().getHeartBeatVersion();
            if (localHbVersion > version) {
                reqdEndPointState = new EndPointState(epState.getHeartBeatState());
            }
            Map<String, ApplicationState> appStateMap = epState.getApplicationStateMap();
            for (Map.Entry<String, ApplicationState> entry : appStateMap.entrySet()) {
                ApplicationState appState = entry.getValue();
                if (appState.getStateVersion() <= version) continue;
                if (reqdEndPointState == null) {
                    reqdEndPointState = new EndPointState(epState.getHeartBeatState());
                }
                String key = entry.getKey();
                if (logger_.isTraceEnabled()) {
                    logger_.trace((Object)("Adding state " + key + ": " + appState.getValue()));
                }
                reqdEndPointState.addApplicationState(key, appState);
            }
        }
        return reqdEndPointState;
    }

    synchronized void join(InetAddress from) {
        if (!from.equals(this.localEndPoint_)) {
            this.liveEndpoints_.add(from);
            this.unreachableEndpoints_.remove(from);
        }
    }

    void notifyFailureDetector(List<GossipDigest> gDigests) {
        IFailureDetector fd = FailureDetector.instance;
        for (GossipDigest gDigest : gDigests) {
            int localVersion;
            int remoteVersion;
            EndPointState localEndPointState = this.endPointStateMap_.get(gDigest.endPoint_);
            if (localEndPointState == null) continue;
            int remoteGeneration = gDigest.generation_;
            int localGeneration = this.endPointStateMap_.get((Object)gDigest.endPoint_).getHeartBeatState().generation_;
            if (remoteGeneration > localGeneration) {
                fd.report(gDigest.endPoint_);
                continue;
            }
            if (remoteGeneration != localGeneration || (remoteVersion = gDigest.maxVersion_) <= (localVersion = this.getMaxEndPointStateVersion(localEndPointState))) continue;
            fd.report(gDigest.endPoint_);
        }
    }

    void notifyFailureDetector(Map<InetAddress, EndPointState> remoteEpStateMap) {
        IFailureDetector fd = FailureDetector.instance;
        for (Map.Entry<InetAddress, EndPointState> entry : remoteEpStateMap.entrySet()) {
            InetAddress endpoint = entry.getKey();
            EndPointState remoteEndPointState = entry.getValue();
            EndPointState localEndPointState = this.endPointStateMap_.get(endpoint);
            if (localEndPointState == null) continue;
            int remoteGeneration = remoteEndPointState.getHeartBeatState().generation_;
            int localGeneration = localEndPointState.getHeartBeatState().generation_;
            if (remoteGeneration > localGeneration) {
                fd.report(endpoint);
                continue;
            }
            if (remoteGeneration != localGeneration) continue;
            int localVersion = this.getMaxEndPointStateVersion(localEndPointState);
            int remoteVersion = remoteEndPointState.getHeartBeatState().getHeartBeatVersion();
            if (remoteVersion <= localVersion) continue;
            fd.report(endpoint);
        }
    }

    void markAlive(InetAddress addr, EndPointState localState) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("marking as alive " + addr));
        }
        if (!localState.isAlive()) {
            this.isAlive(addr, localState, true);
            logger_.info((Object)("InetAddress " + addr + " is now UP"));
        }
    }

    private void handleNewJoin(InetAddress ep, EndPointState epState) {
        if (this.justRemovedEndPoints_.containsKey(ep)) {
            return;
        }
        logger_.info((Object)("Node " + ep + " is now part of the cluster"));
        this.handleMajorStateChange(ep, epState, false);
    }

    private void handleGenerationChange(InetAddress ep, EndPointState epState) {
        logger_.info((Object)("Node " + ep + " has restarted, now UP again"));
        this.handleMajorStateChange(ep, epState, true);
    }

    private void handleMajorStateChange(InetAddress ep, EndPointState epState, boolean isKnownNode) {
        this.endPointStateMap_.put(ep, epState);
        this.isAlive(ep, epState, isKnownNode);
        for (IEndPointStateChangeSubscriber subscriber : this.subscribers_) {
            subscriber.onJoin(ep, epState);
        }
    }

    synchronized void applyStateLocally(Map<InetAddress, EndPointState> epStateMap) {
        for (Map.Entry<InetAddress, EndPointState> entry : epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            if (ep.equals(this.localEndPoint_)) continue;
            EndPointState localEpStatePtr = this.endPointStateMap_.get(ep);
            EndPointState remoteState = entry.getValue();
            if (localEpStatePtr != null) {
                int localGeneration = localEpStatePtr.getHeartBeatState().getGeneration();
                int remoteGeneration = remoteState.getHeartBeatState().getGeneration();
                if (remoteGeneration > localGeneration) {
                    this.handleGenerationChange(ep, remoteState);
                    continue;
                }
                if (remoteGeneration != localGeneration) continue;
                int localMaxVersion = this.getMaxEndPointStateVersion(localEpStatePtr);
                int remoteMaxVersion = this.getMaxEndPointStateVersion(remoteState);
                if (remoteMaxVersion <= localMaxVersion) continue;
                this.markAlive(ep, localEpStatePtr);
                this.applyHeartBeatStateLocally(ep, localEpStatePtr, remoteState);
                this.applyApplicationStateLocally(ep, localEpStatePtr, remoteState);
                continue;
            }
            this.handleNewJoin(ep, remoteState);
        }
    }

    void applyHeartBeatStateLocally(InetAddress addr, EndPointState localState, EndPointState remoteState) {
        HeartBeatState localHbState = localState.getHeartBeatState();
        HeartBeatState remoteHbState = remoteState.getHeartBeatState();
        if (remoteHbState.getGeneration() > localHbState.getGeneration()) {
            localState.setHeartBeatState(remoteHbState);
        }
        if (localHbState.getGeneration() == remoteHbState.getGeneration() && remoteHbState.getHeartBeatVersion() > localHbState.getHeartBeatVersion()) {
            int oldVersion = localHbState.getHeartBeatVersion();
            localState.setHeartBeatState(remoteHbState);
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Updating heartbeat state version to " + localState.getHeartBeatState().getHeartBeatVersion() + " from " + oldVersion + " for " + addr + " ..."));
            }
        }
    }

    void applyApplicationStateLocally(InetAddress addr, EndPointState localStatePtr, EndPointState remoteStatePtr) {
        Map<String, ApplicationState> localAppStateMap = localStatePtr.getApplicationStateMap();
        for (Map.Entry<String, ApplicationState> remoteEntry : remoteStatePtr.getSortedApplicationStates()) {
            int localVersion;
            int remoteVersion;
            String remoteKey = remoteEntry.getKey();
            ApplicationState remoteAppState = remoteEntry.getValue();
            ApplicationState localAppState = localAppStateMap.get(remoteKey);
            if (localAppState == null) {
                localStatePtr.addApplicationState(remoteKey, remoteAppState);
                this.doNotifications(addr, remoteKey, remoteAppState);
                continue;
            }
            int remoteGeneration = remoteStatePtr.getHeartBeatState().getGeneration();
            int localGeneration = localStatePtr.getHeartBeatState().getGeneration();
            assert (remoteGeneration >= localGeneration);
            if (remoteGeneration > localGeneration) {
                localStatePtr.addApplicationState(remoteKey, remoteAppState);
                this.doNotifications(addr, remoteKey, remoteAppState);
                continue;
            }
            if (remoteGeneration != localGeneration || (remoteVersion = remoteAppState.getStateVersion()) <= (localVersion = localAppState.getStateVersion())) continue;
            localStatePtr.addApplicationState(remoteKey, remoteAppState);
            this.doNotifications(addr, remoteKey, remoteAppState);
        }
    }

    void doNotifications(InetAddress addr, String stateName, ApplicationState state) {
        for (IEndPointStateChangeSubscriber subscriber : this.subscribers_) {
            subscriber.onChange(addr, stateName, state);
        }
    }

    synchronized void isAlive(InetAddress addr, EndPointState epState, boolean value) {
        epState.isAlive(value);
        if (value) {
            this.liveEndpoints_.add(addr);
            this.unreachableEndpoints_.remove(addr);
            for (IEndPointStateChangeSubscriber subscriber : this.subscribers_) {
                subscriber.onAlive(addr, epState);
            }
        } else {
            this.liveEndpoints_.remove(addr);
            this.unreachableEndpoints_.add(addr);
            for (IEndPointStateChangeSubscriber subscriber : this.subscribers_) {
                subscriber.onDead(addr, epState);
            }
        }
        if (epState.isAGossiper()) {
            return;
        }
        epState.isAGossiper(true);
    }

    void requestAll(GossipDigest gDigest, List<GossipDigest> deltaGossipDigestList, int remoteGeneration) {
        deltaGossipDigestList.add(new GossipDigest(gDigest.getEndPoint(), remoteGeneration, 0));
    }

    void sendAll(GossipDigest gDigest, Map<InetAddress, EndPointState> deltaEpStateMap, int maxRemoteVersion) {
        EndPointState localEpStatePtr = this.getStateForVersionBiggerThan(gDigest.getEndPoint(), maxRemoteVersion);
        if (localEpStatePtr != null) {
            deltaEpStateMap.put(gDigest.getEndPoint(), localEpStatePtr);
        }
    }

    synchronized void examineGossiper(List<GossipDigest> gDigestList, List<GossipDigest> deltaGossipDigestList, Map<InetAddress, EndPointState> deltaEpStateMap) {
        for (GossipDigest gDigest : gDigestList) {
            int remoteGeneration = gDigest.getGeneration();
            int maxRemoteVersion = gDigest.getMaxVersion();
            EndPointState epStatePtr = this.endPointStateMap_.get(gDigest.getEndPoint());
            if (epStatePtr != null) {
                int localGeneration = epStatePtr.getHeartBeatState().getGeneration();
                int maxLocalVersion = this.getMaxEndPointStateVersion(epStatePtr);
                if (remoteGeneration == localGeneration && maxRemoteVersion == maxLocalVersion) continue;
                if (remoteGeneration > localGeneration) {
                    this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
                }
                if (remoteGeneration < localGeneration) {
                    this.sendAll(gDigest, deltaEpStateMap, 0);
                }
                if (remoteGeneration != localGeneration) continue;
                if (maxRemoteVersion > maxLocalVersion) {
                    deltaGossipDigestList.add(new GossipDigest(gDigest.getEndPoint(), remoteGeneration, maxLocalVersion));
                }
                if (maxRemoteVersion >= maxLocalVersion) continue;
                this.sendAll(gDigest, deltaEpStateMap, maxRemoteVersion);
                continue;
            }
            this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
        }
    }

    public void start(InetAddress localEndPoint, int generationNbr) {
        this.localEndPoint_ = localEndPoint;
        Set<InetAddress> seedHosts = DatabaseDescriptor.getSeeds();
        for (InetAddress seed : seedHosts) {
            if (seed.equals(localEndPoint)) continue;
            this.seeds_.add(seed);
        }
        EndPointState localState = this.endPointStateMap_.get(this.localEndPoint_);
        if (localState == null) {
            HeartBeatState hbState = new HeartBeatState(generationNbr);
            localState = new EndPointState(hbState);
            localState.isAlive(true);
            localState.isAGossiper(true);
            this.endPointStateMap_.put(this.localEndPoint_, localState);
        }
        this.gossipTimer_.schedule((TimerTask)new GossipTimerTask(), 1000L, 1000L);
    }

    public synchronized void addLocalApplicationState(String key, ApplicationState appState) {
        assert (!StorageService.instance.isClientMode());
        EndPointState epState = this.endPointStateMap_.get(this.localEndPoint_);
        assert (epState != null);
        epState.addApplicationState(key, appState);
    }

    public void stop() {
        this.gossipTimer_.cancel();
        this.gossipTimer_ = new Timer(false);
    }

    public static class GossipDigestAck2VerbHandler
    implements IVerbHandler {
        private static Logger logger_ = Logger.getLogger(GossipDigestAck2VerbHandler.class);

        @Override
        public void doVerb(Message message) {
            GossipDigestAck2Message gDigestAck2Message;
            InetAddress from = message.getFrom();
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Received a GossipDigestAck2Message from " + from));
            }
            byte[] bytes = message.getMessageBody();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                gDigestAck2Message = GossipDigestAck2Message.serializer().deserialize(dis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Map<InetAddress, EndPointState> remoteEpStateMap = gDigestAck2Message.getEndPointStateMap();
            instance.notifyFailureDetector(remoteEpStateMap);
            instance.applyStateLocally(remoteEpStateMap);
        }
    }

    public static class GossipDigestAckVerbHandler
    implements IVerbHandler {
        private static Logger logger_ = Logger.getLogger(GossipDigestAckVerbHandler.class);

        @Override
        public void doVerb(Message message) {
            InetAddress from = message.getFrom();
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Received a GossipDigestAckMessage from " + from));
            }
            byte[] bytes = message.getMessageBody();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                GossipDigestAckMessage gDigestAckMessage = GossipDigestAckMessage.serializer().deserialize(dis);
                List<GossipDigest> gDigestList = gDigestAckMessage.getGossipDigestList();
                Map<InetAddress, EndPointState> epStateMap = gDigestAckMessage.getEndPointStateMap();
                if (epStateMap.size() > 0) {
                    instance.notifyFailureDetector(epStateMap);
                    instance.applyStateLocally(epStateMap);
                }
                HashMap<InetAddress, EndPointState> deltaEpStateMap = new HashMap<InetAddress, EndPointState>();
                for (GossipDigest gDigest : gDigestList) {
                    InetAddress addr = gDigest.getEndPoint();
                    EndPointState localEpStatePtr = instance.getStateForVersionBiggerThan(addr, gDigest.getMaxVersion());
                    if (localEpStatePtr == null) continue;
                    deltaEpStateMap.put(addr, localEpStatePtr);
                }
                GossipDigestAck2Message gDigestAck2 = new GossipDigestAck2Message(deltaEpStateMap);
                Message gDigestAck2Message = instance.makeGossipDigestAck2Message(gDigestAck2);
                if (logger_.isTraceEnabled()) {
                    logger_.trace((Object)("Sending a GossipDigestAck2Message to " + from));
                }
                MessagingService.instance.sendOneWay(gDigestAck2Message, from);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class GossipDigestSynVerbHandler
    implements IVerbHandler {
        private static Logger logger_ = Logger.getLogger(GossipDigestSynVerbHandler.class);

        @Override
        public void doVerb(Message message) {
            InetAddress from = message.getFrom();
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Received a GossipDigestSynMessage from " + from));
            }
            byte[] bytes = message.getMessageBody();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                GossipDigestSynMessage gDigestMessage = GossipDigestSynMessage.serializer().deserialize(dis);
                if (!gDigestMessage.clusterId_.equals(DatabaseDescriptor.getClusterName())) {
                    logger_.warn((Object)("ClusterName mismatch from " + from + " " + gDigestMessage.clusterId_ + "!=" + DatabaseDescriptor.getClusterName()));
                    return;
                }
                List<GossipDigest> gDigestList = gDigestMessage.getGossipDigests();
                instance.notifyFailureDetector(gDigestList);
                this.doSort(gDigestList);
                ArrayList<GossipDigest> deltaGossipDigestList = new ArrayList<GossipDigest>();
                HashMap<InetAddress, EndPointState> deltaEpStateMap = new HashMap<InetAddress, EndPointState>();
                instance.examineGossiper(gDigestList, deltaGossipDigestList, deltaEpStateMap);
                GossipDigestAckMessage gDigestAck = new GossipDigestAckMessage(deltaGossipDigestList, deltaEpStateMap);
                Message gDigestAckMessage = instance.makeGossipDigestAckMessage(gDigestAck);
                if (logger_.isTraceEnabled()) {
                    logger_.trace((Object)("Sending a GossipDigestAckMessage to " + from));
                }
                MessagingService.instance.sendOneWay(gDigestAckMessage, from);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void doSort(List<GossipDigest> gDigestList) {
            HashMap<InetAddress, GossipDigest> epToDigestMap = new HashMap<InetAddress, GossipDigest>();
            for (GossipDigest gDigest : gDigestList) {
                epToDigestMap.put(gDigest.getEndPoint(), gDigest);
            }
            ArrayList<GossipDigest> diffDigests = new ArrayList<GossipDigest>();
            for (GossipDigest gDigest : gDigestList) {
                InetAddress ep = gDigest.getEndPoint();
                EndPointState epState = instance.getEndPointStateForEndPoint(ep);
                int version = epState != null ? instance.getMaxEndPointStateVersion(epState) : 0;
                int diffVersion = Math.abs(version - gDigest.getMaxVersion());
                diffDigests.add(new GossipDigest(ep, gDigest.getGeneration(), diffVersion));
            }
            gDigestList.clear();
            Collections.sort(diffDigests);
            int size = diffDigests.size();
            for (int i = size - 1; i >= 0; --i) {
                gDigestList.add((GossipDigest)epToDigestMap.get(((GossipDigest)diffDigests.get(i)).getEndPoint()));
            }
        }
    }

    public static class JoinVerbHandler
    implements IVerbHandler {
        private static Logger logger_ = Logger.getLogger(JoinVerbHandler.class);

        @Override
        public void doVerb(Message message) {
            JoinMessage joinMessage;
            InetAddress from = message.getFrom();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Received a JoinMessage from " + from));
            }
            byte[] bytes = message.getMessageBody();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                joinMessage = JoinMessage.serializer().deserialize(dis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (joinMessage.clusterId_.equals(DatabaseDescriptor.getClusterName())) {
                instance.join(from);
            } else {
                logger_.warn((Object)("ClusterName mismatch from " + from + " " + joinMessage.clusterId_ + "!=" + DatabaseDescriptor.getClusterName()));
            }
        }
    }

    private class GossipTimerTask
    extends TimerTask {
        private GossipTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Gossiper gossiper = instance;
                synchronized (gossiper) {
                    Gossiper.this.endPointStateMap_.get(Gossiper.this.localEndPoint_).getHeartBeatState().updateHeartBeat();
                    ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>();
                    instance.makeRandomGossipDigest(gDigests);
                    if (gDigests.size() > 0) {
                        Message message = Gossiper.this.makeGossipDigestSynMessage(gDigests);
                        boolean gossipedToSeed = Gossiper.this.doGossipToLiveMember(message);
                        Gossiper.this.doGossipToUnreachableMember(message);
                        if (!gossipedToSeed || Gossiper.this.liveEndpoints_.size() < Gossiper.this.seeds_.size()) {
                            Gossiper.this.doGossipToSeed(message);
                        }
                        if (logger_.isTraceEnabled()) {
                            logger_.trace((Object)"Performing status check ...");
                        }
                        Gossiper.this.doStatusCheck();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

