/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ColumnFamilyInputFormat
extends InputFormat<String, SortedMap<byte[], IColumn>> {
    private static final Logger logger = Logger.getLogger(StorageService.class);

    private void validateConfiguration(Configuration conf) {
        if (ConfigHelper.getKeyspace(conf) == null || ConfigHelper.getColumnFamily(conf) == null) {
            throw new UnsupportedOperationException("you must set the keyspace and columnfamily with setColumnFamily()");
        }
        if (ConfigHelper.getSlicePredicate(conf) == null) {
            throw new UnsupportedOperationException("you must set the predicate with setPredicate");
        }
    }

    /*
     * Exception decompiling
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getSubSplits(TokenRange range, int splitsize) throws IOException {
        List<String> splits;
        TSocket socket = new TSocket(range.endpoints.get(0), DatabaseDescriptor.getThriftPort());
        TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)socket, false, false);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        try {
            socket.open();
        }
        catch (TTransportException e) {
            throw new IOException(e);
        }
        try {
            splits = client.describe_splits(range.start_token, range.end_token, splitsize);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return splits;
    }

    private List<TokenRange> getRangeMap(String keyspace) throws IOException {
        List<TokenRange> map;
        TSocket socket = new TSocket(DatabaseDescriptor.getSeeds().iterator().next().getHostAddress(), DatabaseDescriptor.getThriftPort());
        TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)socket, false, false);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        try {
            socket.open();
        }
        catch (TTransportException e) {
            throw new IOException(e);
        }
        try {
            map = client.describe_ring(keyspace);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public RecordReader<String, SortedMap<byte[], IColumn>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new ColumnFamilyRecordReader();
    }

    class SplitCallable
    implements Callable<List<InputSplit>> {
        private TokenRange range;
        private int splitsize;

        public SplitCallable(TokenRange tr, int splitsize) {
            this.range = tr;
            this.splitsize = splitsize;
        }

        @Override
        public List<InputSplit> call() throws Exception {
            int i;
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            List tokens = ColumnFamilyInputFormat.this.getSubSplits(this.range, this.splitsize);
            String[] endpoints = this.range.endpoints.toArray(new String[this.range.endpoints.size()]);
            for (i = 0; i < endpoints.length; ++i) {
                endpoints[i] = InetAddress.getByName(endpoints[i]).getHostName();
            }
            for (i = 1; i < tokens.size(); ++i) {
                ColumnFamilySplit split = new ColumnFamilySplit((String)tokens.get(i - 1), (String)tokens.get(i), endpoints);
                logger.debug((Object)("adding " + (Object)((Object)split)));
                splits.add(split);
            }
            return splits;
        }
    }
}

