/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ColumnFamilyRecordReader
extends RecordReader<String, SortedMap<byte[], IColumn>> {
    private ColumnFamilySplit split;
    private RowIterator iter;
    private Pair<String, SortedMap<byte[], IColumn>> currentRow;
    private SlicePredicate predicate;
    private int totalRowCount;
    private int batchRowCount;
    private String cfName;
    private String keyspace;

    public void close() {
    }

    public String getCurrentKey() {
        return (String)this.currentRow.left;
    }

    public SortedMap<byte[], IColumn> getCurrentValue() {
        return (SortedMap)this.currentRow.right;
    }

    public float getProgress() {
        return (float)this.iter.rowsRead() / (float)this.totalRowCount;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = context.getConfiguration();
        this.predicate = ConfigHelper.getSlicePredicate(conf);
        this.totalRowCount = ConfigHelper.getInputSplitSize(conf);
        this.batchRowCount = ConfigHelper.getRangeBatchSize(conf);
        this.cfName = ConfigHelper.getColumnFamily(conf);
        this.keyspace = ConfigHelper.getKeyspace(conf);
        this.iter = new RowIterator();
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.iter.hasNext()) {
            return false;
        }
        this.currentRow = (Pair)this.iter.next();
        return true;
    }

    private IColumn unthriftify(ColumnOrSuperColumn cosc) {
        if (cosc.column == null) {
            return this.unthriftifySuper(cosc.super_column);
        }
        return this.unthriftifySimple(cosc.column);
    }

    private IColumn unthriftifySuper(org.apache.cassandra.thrift.SuperColumn super_column) {
        AbstractType subComparator = DatabaseDescriptor.getSubComparator(this.keyspace, this.cfName);
        SuperColumn sc = new SuperColumn(super_column.name, subComparator);
        for (org.apache.cassandra.thrift.Column column : super_column.columns) {
            sc.addColumn(this.unthriftifySimple(column));
        }
        return sc;
    }

    private IColumn unthriftifySimple(org.apache.cassandra.thrift.Column column) {
        return new Column(column.name, column.value, column.timestamp);
    }

    private class RowIterator
    extends AbstractIterator<Pair<String, SortedMap<byte[], IColumn>>> {
        private List<KeySlice> rows;
        private String startToken;
        private int totalRead = 0;
        private int i = 0;
        private AbstractType comparator = DatabaseDescriptor.getComparator(ColumnFamilyRecordReader.access$100(ColumnFamilyRecordReader.this), ColumnFamilyRecordReader.access$200(ColumnFamilyRecordReader.this));

        private RowIterator() {
        }

        private void maybeInit() {
            if (this.rows != null && this.i >= this.rows.size()) {
                this.rows = null;
            }
            if (this.rows != null) {
                return;
            }
            TSocket socket = new TSocket(this.getLocation(), DatabaseDescriptor.getThriftPort());
            TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)socket, false, false);
            Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
            try {
                socket.open();
            }
            catch (TTransportException e) {
                throw new RuntimeException(e);
            }
            if (this.startToken == null) {
                this.startToken = ColumnFamilyRecordReader.this.split.getStartToken();
            } else if (this.startToken.equals(ColumnFamilyRecordReader.this.split.getEndToken())) {
                this.rows = null;
                return;
            }
            KeyRange keyRange = new KeyRange(ColumnFamilyRecordReader.this.batchRowCount).setStart_token(this.startToken).setEnd_token(ColumnFamilyRecordReader.this.split.getEndToken());
            try {
                this.rows = client.get_range_slices(ColumnFamilyRecordReader.this.keyspace, new ColumnParent(ColumnFamilyRecordReader.this.cfName), ColumnFamilyRecordReader.this.predicate, keyRange, ConsistencyLevel.ONE);
                if (this.rows.isEmpty()) {
                    this.rows = null;
                    return;
                }
                this.i = 0;
                KeySlice lastRow = this.rows.get(this.rows.size() - 1);
                IPartitioner p = DatabaseDescriptor.getPartitioner();
                this.startToken = p.getTokenFactory().toString(p.getToken(lastRow.getKey()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String getLocation() {
            InetAddress[] localAddresses = new InetAddress[]{};
            try {
                localAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)e);
            }
            for (InetAddress address : localAddresses) {
                for (String location : ColumnFamilyRecordReader.this.split.getLocations()) {
                    InetAddress locationAddress = null;
                    try {
                        locationAddress = InetAddress.getByName(location);
                    }
                    catch (UnknownHostException e) {
                        throw new AssertionError((Object)e);
                    }
                    if (!address.equals(locationAddress)) continue;
                    return location;
                }
            }
            return ColumnFamilyRecordReader.this.split.getLocations()[0];
        }

        public int rowsRead() {
            return this.totalRead;
        }

        protected Pair<String, SortedMap<byte[], IColumn>> computeNext() {
            this.maybeInit();
            if (this.rows == null) {
                return (Pair)this.endOfData();
            }
            ++this.totalRead;
            KeySlice ks = this.rows.get(this.i++);
            TreeMap<byte[], IColumn> map = new TreeMap<byte[], IColumn>(this.comparator);
            for (ColumnOrSuperColumn cosc : ks.columns) {
                IColumn column = ColumnFamilyRecordReader.this.unthriftify(cosc);
                map.put(column.name(), column);
            }
            return new Pair<String, SortedMap<byte[], IColumn>>(ks.key, map);
        }
    }
}

