/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ConfigHelper {
    private static final String KEYSPACE_CONFIG = "cassandra.input.keyspace";
    private static final String COLUMNFAMILY_CONFIG = "cassandra.input.columnfamily";
    private static final String PREDICATE_CONFIG = "cassandra.input.predicate";
    private static final String INPUT_SPLIT_SIZE_CONFIG = "cassandra.input.split.size";
    private static final int DEFAULT_SPLIT_SIZE = 65536;
    private static final String RANGE_BATCH_SIZE_CONFIG = "cassandra.range.batch.size";
    private static final int DEFAULT_RANGE_BATCH_SIZE = 4096;

    public static void setColumnFamily(Configuration conf, String keyspace, String columnFamily) {
        if (keyspace == null) {
            throw new UnsupportedOperationException("keyspace may not be null");
        }
        if (columnFamily == null) {
            throw new UnsupportedOperationException("columnfamily may not be null");
        }
        try {
            ThriftValidation.validateColumnFamily(keyspace, columnFamily);
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        conf.set(KEYSPACE_CONFIG, keyspace);
        conf.set(COLUMNFAMILY_CONFIG, columnFamily);
    }

    public static void setRangeBatchSize(Configuration conf, int batchsize) {
        conf.setInt(RANGE_BATCH_SIZE_CONFIG, batchsize);
    }

    public static int getRangeBatchSize(Configuration conf) {
        return conf.getInt(RANGE_BATCH_SIZE_CONFIG, 4096);
    }

    public static void setInputSplitSize(Configuration conf, int splitsize) {
        conf.setInt(INPUT_SPLIT_SIZE_CONFIG, splitsize);
    }

    public static int getInputSplitSize(Configuration conf) {
        return conf.getInt(INPUT_SPLIT_SIZE_CONFIG, 65536);
    }

    public static void setSlicePredicate(Configuration conf, SlicePredicate predicate) {
        conf.set(PREDICATE_CONFIG, ConfigHelper.predicateToString(predicate));
    }

    public static SlicePredicate getSlicePredicate(Configuration conf) {
        return ConfigHelper.predicateFromString(conf.get(PREDICATE_CONFIG));
    }

    private static String predicateToString(SlicePredicate predicate) {
        assert (predicate != null);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        try {
            return serializer.toString((TBase)predicate, "UTF-8");
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    private static SlicePredicate predicateFromString(String st) {
        assert (st != null);
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
        SlicePredicate predicate = new SlicePredicate();
        try {
            deserializer.deserialize((TBase)predicate, st, "UTF-8");
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        return predicate;
    }

    public static String getKeyspace(Configuration conf) {
        return conf.get(KEYSPACE_CONFIG);
    }

    public static String getColumnFamily(Configuration conf) {
        return conf.get(COLUMNFAMILY_CONFIG);
    }
}

