/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.IteratingRow;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableScanner;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.log4j.Logger;

public class CompactionIterator
extends ReducingIterator<IteratingRow, CompactedRow>
implements Closeable {
    private static Logger logger = Logger.getLogger(CompactionIterator.class);
    protected static final int FILE_BUFFER_SIZE = 0x100000;
    private final List<IteratingRow> rows = new ArrayList<IteratingRow>();
    private final int gcBefore;
    private final boolean major;
    private long totalBytes = 0L;
    private long bytesRead = 0L;
    private long row = 0L;

    public CompactionIterator(Iterable<SSTableReader> sstables, int gcBefore, boolean major) throws IOException {
        this((Iterator)CompactionIterator.getCollatingIterator(sstables), gcBefore, major);
    }

    protected CompactionIterator(Iterator iter, int gcBefore, boolean major) {
        super(iter);
        for (SSTableScanner scanner : this.getScanners()) {
            this.totalBytes += scanner.getFileLength();
        }
        this.gcBefore = gcBefore;
        this.major = major;
    }

    protected static CollatingIterator getCollatingIterator(Iterable<SSTableReader> sstables) throws IOException {
        CollatingIterator iter = FBUtilities.getCollatingIterator();
        for (SSTableReader sstable : sstables) {
            iter.addIterator((Iterator)sstable.getScanner(0x100000));
        }
        return iter;
    }

    @Override
    protected boolean isEqual(IteratingRow o1, IteratingRow o2) {
        return o1.getKey().equals(o2.getKey());
    }

    @Override
    public void reduce(IteratingRow current) {
        this.rows.add(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompactedRow getReduced() {
        DecoratedKey key;
        DataOutputBuffer buffer;
        block16: {
            assert (this.rows.size() > 0);
            buffer = new DataOutputBuffer();
            key = this.rows.get(0).getKey();
            try {
                if (this.rows.size() > 1 || this.major) {
                    ColumnFamily cfPurged;
                    ColumnFamily cf = null;
                    for (IteratingRow row : this.rows) {
                        ColumnFamily thisCF;
                        try {
                            thisCF = row.getColumnFamily();
                        }
                        catch (IOException e) {
                            logger.error((Object)("Skipping row " + key + " in " + row.getPath()), (Throwable)e);
                            continue;
                        }
                        if (cf == null) {
                            cf = thisCF;
                            continue;
                        }
                        cf.addAll(thisCF);
                    }
                    ColumnFamily columnFamily = cfPurged = this.major ? ColumnFamilyStore.removeDeleted(cf, this.gcBefore) : cf;
                    if (cfPurged == null) {
                        CompactedRow compactedRow = null;
                        return compactedRow;
                    }
                    ColumnFamily.serializer().serializeWithIndexes(cfPurged, buffer);
                    break block16;
                }
                assert (this.rows.size() == 1);
                try {
                    this.rows.get(0).echoData(buffer);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            finally {
                this.rows.clear();
                if (this.row++ % 1000L == 0L) {
                    this.bytesRead = 0L;
                    for (SSTableScanner scanner : this.getScanners()) {
                        this.bytesRead += scanner.getFilePointer();
                    }
                }
            }
        }
        return new CompactedRow(key, buffer);
    }

    @Override
    public void close() throws IOException {
        for (SSTableScanner scanner : this.getScanners()) {
            scanner.close();
        }
    }

    protected Iterable<SSTableScanner> getScanners() {
        return ((CollatingIterator)this.source).getIterators();
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public static class CompactedRow {
        public final DecoratedKey key;
        public final DataOutputBuffer buffer;

        public CompactedRow(DecoratedKey key, DataOutputBuffer buffer) {
            this.key = key;
            this.buffer = buffer;
        }
    }
}

