/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;

public class IndexSummary {
    public static final int INDEX_INTERVAL = 128;
    private ArrayList<KeyPosition> indexPositions;
    private Map<KeyPosition, SSTable.PositionSize> spannedIndexDataPositions;
    private Map<Long, KeyPosition> spannedIndexPositions;
    private int keysWritten = 0;
    private long lastIndexPosition;

    public void maybeAddEntry(DecoratedKey decoratedKey, long dataPosition, long dataSize, long indexPosition, long nextIndexPosition) {
        boolean spannedIndexEntry;
        boolean bl = spannedIndexEntry = DatabaseDescriptor.getIndexAccessMode() == DatabaseDescriptor.DiskAccessMode.mmap && SSTableReader.bufferIndex(indexPosition) != SSTableReader.bufferIndex(nextIndexPosition);
        if (this.keysWritten++ % 128 == 0 || spannedIndexEntry) {
            if (this.indexPositions == null) {
                this.indexPositions = new ArrayList();
            }
            KeyPosition info = new KeyPosition(decoratedKey, indexPosition);
            this.indexPositions.add(info);
            if (spannedIndexEntry) {
                if (this.spannedIndexDataPositions == null) {
                    this.spannedIndexDataPositions = new HashMap<KeyPosition, SSTable.PositionSize>();
                    this.spannedIndexPositions = new HashMap<Long, KeyPosition>();
                }
                this.spannedIndexDataPositions.put(info, new SSTable.PositionSize(dataPosition, dataSize));
                this.spannedIndexPositions.put(info.indexPosition, info);
            }
        }
        this.lastIndexPosition = indexPosition;
    }

    public List<KeyPosition> getIndexPositions() {
        return this.indexPositions;
    }

    public void complete() {
        this.indexPositions.trimToSize();
    }

    public SSTable.PositionSize getSpannedDataPosition(KeyPosition sampledPosition) {
        if (this.spannedIndexDataPositions == null) {
            return null;
        }
        return this.spannedIndexDataPositions.get(sampledPosition);
    }

    public KeyPosition getSpannedIndexPosition(long nextIndexPosition) {
        return this.spannedIndexPositions == null ? null : this.spannedIndexPositions.get(nextIndexPosition);
    }

    public SSTable.PositionSize getSpannedDataPosition(long nextIndexPosition) {
        if (this.spannedIndexDataPositions == null) {
            return null;
        }
        KeyPosition info = this.spannedIndexPositions.get(nextIndexPosition);
        if (info == null) {
            return null;
        }
        return this.spannedIndexDataPositions.get(info);
    }

    public long getLastIndexPosition() {
        return this.lastIndexPosition;
    }

    public static class KeyPosition
    implements Comparable<KeyPosition> {
        public final DecoratedKey key;
        public final long indexPosition;

        public KeyPosition(DecoratedKey key, long indexPosition) {
            this.key = key;
            this.indexPosition = indexPosition;
        }

        @Override
        public int compareTo(KeyPosition kp) {
            return this.key.compareTo(kp.key);
        }

        public String toString() {
            return this.key + ":" + this.indexPosition;
        }
    }
}

