/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import com.google.common.collect.AbstractIterator;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.IndexHelper;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.service.StorageService;

public class IteratingRow
extends AbstractIterator<IColumn>
implements Comparable<IteratingRow> {
    private final DecoratedKey key;
    private final long finishedAt;
    private final BufferedRandomAccessFile file;
    private SSTableReader sstable;
    private long dataStart;

    public IteratingRow(BufferedRandomAccessFile file, SSTableReader sstable) throws IOException {
        this.file = file;
        this.sstable = sstable;
        this.key = StorageService.getPartitioner().convertFromDiskFormat(file.readUTF());
        int dataSize = file.readInt();
        this.dataStart = file.getFilePointer();
        this.finishedAt = this.dataStart + (long)dataSize;
    }

    public DecoratedKey getKey() {
        return this.key;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public void echoData(DataOutput out) throws IOException {
        this.file.seek(this.dataStart);
        while (this.file.getFilePointer() < this.finishedAt) {
            out.write(this.file.readByte());
        }
    }

    public ColumnFamily getColumnFamily() throws IOException {
        this.file.seek(this.dataStart);
        IndexHelper.skipBloomFilter(this.file);
        IndexHelper.skipIndex(this.file);
        return ColumnFamily.serializer().deserializeFromSSTable(this.sstable, this.file);
    }

    public void skipRemaining() throws IOException {
        this.file.seek(this.finishedAt);
    }

    public long getEndPosition() {
        return this.finishedAt;
    }

    protected IColumn computeNext() {
        try {
            assert (this.file.getFilePointer() <= this.finishedAt);
            if (this.file.getFilePointer() == this.finishedAt) {
                return (IColumn)this.endOfData();
            }
            return this.sstable.getColumnSerializer().deserialize(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(IteratingRow o) {
        return this.key.compareTo(o.key);
    }
}

