/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.IndexSummary;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class SSTable {
    static final Logger logger = Logger.getLogger(SSTable.class);
    public static final int FILES_ON_DISK = 3;
    protected String path;
    protected IPartitioner partitioner;
    protected BloomFilter bf;
    protected String columnFamilyName;
    protected IndexSummary indexSummary;
    public static final String TEMPFILE_MARKER = "tmp";

    public SSTable(String filename, IPartitioner partitioner) {
        assert (filename.endsWith("-Data.db"));
        this.columnFamilyName = SSTable.parseColumnFamilyName(filename);
        this.path = filename;
        this.partitioner = partitioner;
    }

    protected static String parseColumnFamilyName(String filename) {
        return new File(filename).getName().split("-")[0];
    }

    public static String indexFilename(String dataFile) {
        Object[] parts = dataFile.split("-");
        parts[parts.length - 1] = "Index.db";
        return StringUtils.join((Object[])parts, (String)"-");
    }

    public String indexFilename() {
        return SSTable.indexFilename(this.path);
    }

    protected static String compactedFilename(String dataFile) {
        Object[] parts = dataFile.split("-");
        parts[parts.length - 1] = "Compacted";
        return StringUtils.join((Object[])parts, (String)"-");
    }

    public static boolean deleteIfCompacted(String dataFilename) throws IOException {
        if (new File(SSTable.compactedFilename(dataFilename)).exists()) {
            FileUtils.deleteWithConfirm(new File(dataFilename));
            FileUtils.deleteWithConfirm(new File(SSTable.indexFilename(dataFilename)));
            FileUtils.deleteWithConfirm(new File(SSTable.filterFilename(dataFilename)));
            FileUtils.deleteWithConfirm(new File(SSTable.compactedFilename(dataFilename)));
            logger.info((Object)("Deleted " + dataFilename));
            return true;
        }
        return false;
    }

    protected String compactedFilename() {
        return SSTable.compactedFilename(this.path);
    }

    protected static String filterFilename(String dataFile) {
        Object[] parts = dataFile.split("-");
        parts[parts.length - 1] = "Filter.db";
        return StringUtils.join((Object[])parts, (String)"-");
    }

    public String filterFilename() {
        return SSTable.filterFilename(this.path);
    }

    public String getFilename() {
        return this.path;
    }

    public List<String> getAllFilenames() {
        return Arrays.asList(this.indexFilename(), this.filterFilename(), this.getFilename());
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public String getTableName() {
        return SSTable.parseTableName(this.path);
    }

    public static String parseTableName(String filename) {
        return new File(filename).getParentFile().getName();
    }

    public static long getTotalBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.length();
        }
        return sum;
    }

    public long bytesOnDisk() {
        long bytes = 0L;
        for (String fname : this.getAllFilenames()) {
            bytes += new File(fname).length();
        }
        return bytes;
    }

    public String toString() {
        return this.getClass().getName() + "(" + "path='" + this.path + '\'' + ')';
    }

    public static class PositionSize {
        public final long position;
        public final long size;

        public PositionSize(long position, long size) {
            this.position = position;
            this.size = size;
        }
    }
}

