/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableTracker;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.log4j.Logger;

public class SSTableDeletingReference
extends PhantomReference<SSTableReader> {
    private static final Logger logger = Logger.getLogger(SSTableDeletingReference.class);
    private static final Timer timer = new Timer("SSTABLE-CLEANUP-TIMER");
    public static final int RETRY_DELAY = 10000;
    private final SSTableTracker tracker;
    public final String path;
    private final long size;
    private boolean deleteOnCleanup;

    SSTableDeletingReference(SSTableTracker tracker, SSTableReader referent, ReferenceQueue<? super SSTableReader> q) {
        super(referent, q);
        this.tracker = tracker;
        this.path = referent.path;
        this.size = referent.bytesOnDisk();
    }

    public void deleteOnCleanup() {
        this.deleteOnCleanup = true;
    }

    public void cleanup() throws IOException {
        if (this.deleteOnCleanup) {
            timer.schedule((TimerTask)new CleanupTask(), 10000L);
        }
    }

    private class CleanupTask
    extends TimerTask {
        int attempts = 0;

        private CleanupTask() {
        }

        @Override
        public void run() {
            File datafile = new File(SSTableDeletingReference.this.path);
            if (!datafile.delete()) {
                if (this.attempts++ < 10) {
                    timer.schedule((TimerTask)this, 10000L);
                    return;
                }
                throw new RuntimeException("Unable to delete " + SSTableDeletingReference.this.path);
            }
            try {
                FileUtils.deleteWithConfirm(new File(SSTable.indexFilename(SSTableDeletingReference.this.path)));
                FileUtils.deleteWithConfirm(new File(SSTable.filterFilename(SSTableDeletingReference.this.path)));
                FileUtils.deleteWithConfirm(new File(SSTable.compactedFilename(SSTableDeletingReference.this.path)));
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            SSTableDeletingReference.this.tracker.spaceReclaimed(SSTableDeletingReference.this.size);
            logger.info((Object)("Deleted " + SSTableDeletingReference.this.path));
        }
    }
}

