/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.cache.InstrumentedCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.IndexSummary;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableDeletingReference;
import org.apache.cassandra.io.SSTableScanner;
import org.apache.cassandra.io.SSTableTracker;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MappedFileDataInput;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.log4j.Logger;

public class SSTableReader
extends SSTable
implements Comparable<SSTableReader> {
    private static final Logger logger = Logger.getLogger(SSTableReader.class);
    private static final Set<Reference<SSTableReader>> finalizers = new HashSet<Reference<SSTableReader>>();
    private static final ReferenceQueue<SSTableReader> finalizerQueue = new ReferenceQueue<SSTableReader>(){
        {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        SSTableDeletingReference r = null;
                        try {
                            r = (SSTableDeletingReference)finalizerQueue.remove();
                            finalizers.remove(r);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        try {
                            r.cleanup();
                            continue;
                        }
                        catch (IOException e) {
                            logger.error((Object)("Error deleting " + r.path), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            };
            new Thread(runnable, "SSTABLE-DELETER").start();
        }
    };
    static long BUFFER_SIZE = Integer.MAX_VALUE;
    private volatile SSTableDeletingReference phantomReference;
    private final MappedByteBuffer[] indexBuffers;
    private final MappedByteBuffer[] buffers;
    private InstrumentedCache<Pair<String, DecoratedKey>, SSTable.PositionSize> keyCache;

    public static int indexInterval() {
        return 128;
    }

    public static long getApproximateKeyCount(Iterable<SSTableReader> sstables) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            int indexKeyCount = sstable.getIndexPositions().size();
            count += (long)((indexKeyCount + 1) * 128);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("index size for bloom filter calc for file  : " + sstable.getFilename() + "   : " + count));
        }
        return count;
    }

    public static SSTableReader open(String dataFileName) throws IOException {
        return SSTableReader.open(dataFileName, StorageService.getPartitioner());
    }

    public static SSTableReader open(String dataFileName, IPartitioner partitioner) throws IOException {
        assert (partitioner != null);
        long start = System.currentTimeMillis();
        SSTableReader sstable = new SSTableReader(dataFileName, partitioner);
        logger.info((Object)("Sampling index for " + dataFileName));
        sstable.loadIndexFile();
        sstable.loadBloomFilter();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("INDEX LOAD TIME for " + dataFileName + ": " + (System.currentTimeMillis() - start) + " ms."));
        }
        return sstable;
    }

    SSTableReader(String filename, IPartitioner partitioner, IndexSummary indexSummary, BloomFilter bloomFilter) throws IOException {
        super(filename, partitioner);
        if (DatabaseDescriptor.getIndexAccessMode() == DatabaseDescriptor.DiskAccessMode.mmap) {
            long indexLength = new File(this.indexFilename()).length();
            int bufferCount = 1 + (int)(indexLength / BUFFER_SIZE);
            this.indexBuffers = new MappedByteBuffer[bufferCount];
            long remaining = indexLength;
            for (int i = 0; i < bufferCount; ++i) {
                this.indexBuffers[i] = SSTableReader.mmap(this.indexFilename(), (long)i * BUFFER_SIZE, (int)Math.min(remaining, BUFFER_SIZE));
                remaining -= BUFFER_SIZE;
            }
        } else {
            assert (DatabaseDescriptor.getIndexAccessMode() == DatabaseDescriptor.DiskAccessMode.standard);
            this.indexBuffers = null;
        }
        if (DatabaseDescriptor.getDiskAccessMode() == DatabaseDescriptor.DiskAccessMode.mmap) {
            int bufferCount = 1 + (int)(new File(this.path).length() / BUFFER_SIZE);
            this.buffers = new MappedByteBuffer[bufferCount];
            long remaining = this.length();
            for (int i = 0; i < bufferCount; ++i) {
                this.buffers[i] = SSTableReader.mmap(this.path, (long)i * BUFFER_SIZE, (int)Math.min(remaining, BUFFER_SIZE));
                remaining -= BUFFER_SIZE;
            }
        } else {
            assert (DatabaseDescriptor.getDiskAccessMode() == DatabaseDescriptor.DiskAccessMode.standard);
            this.buffers = null;
        }
        this.indexSummary = indexSummary;
        this.bf = bloomFilter;
    }

    public void setTrackedBy(SSTableTracker tracker) {
        this.phantomReference = new SSTableDeletingReference(tracker, this, finalizerQueue);
        finalizers.add(this.phantomReference);
        this.keyCache = tracker.getKeyCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MappedByteBuffer mmap(String filename, long start, int size) throws IOException {
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (FileNotFoundException e) {
            throw new IOError(e);
        }
        try {
            MappedByteBuffer mappedByteBuffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, start, size);
            return mappedByteBuffer;
        }
        finally {
            raf.close();
        }
    }

    private SSTableReader(String filename, IPartitioner partitioner) throws IOException {
        this(filename, partitioner, null, null);
    }

    public List<IndexSummary.KeyPosition> getIndexPositions() {
        return this.indexSummary.getIndexPositions();
    }

    public long estimatedKeys() {
        return this.indexSummary.getIndexPositions().size() * 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBloomFilter() throws IOException {
        DataInputStream stream = new DataInputStream(new FileInputStream(this.filterFilename()));
        try {
            this.bf = BloomFilter.serializer().deserialize(stream);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadIndexFile() throws IOException {
        this.indexSummary = new IndexSummary();
        BufferedRandomAccessFile input = new BufferedRandomAccessFile(this.indexFilename(), "r");
        try {
            long indexPosition;
            long indexSize = input.length();
            while ((indexPosition = input.getFilePointer()) != indexSize) {
                long nextDataPosition;
                DecoratedKey decoratedKey = this.partitioner.convertFromDiskFormat(input.readUTF());
                long dataPosition = input.readLong();
                long nextIndexPosition = input.getFilePointer();
                if (input.isEOF()) {
                    nextDataPosition = this.length();
                } else {
                    input.readUTF();
                    nextDataPosition = input.readLong();
                    input.seek(nextIndexPosition);
                }
                this.indexSummary.maybeAddEntry(decoratedKey, dataPosition, nextDataPosition - dataPosition, indexPosition, nextIndexPosition);
            }
            this.indexSummary.complete();
        }
        finally {
            input.close();
        }
    }

    private IndexSummary.KeyPosition getIndexScanPosition(DecoratedKey decoratedKey) {
        assert (this.indexSummary.getIndexPositions() != null && this.indexSummary.getIndexPositions().size() > 0);
        int index = Collections.binarySearch(this.indexSummary.getIndexPositions(), new IndexSummary.KeyPosition(decoratedKey, -1L));
        if (index < 0) {
            int greaterThan = (index + 1) * -1;
            if (greaterThan == 0) {
                return null;
            }
            return this.indexSummary.getIndexPositions().get(greaterThan - 1);
        }
        return this.indexSummary.getIndexPositions().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTable.PositionSize getPosition(DecoratedKey decoratedKey) throws IOException {
        FileDataInput input;
        SSTable.PositionSize cachedPosition;
        if (!this.bf.isPresent(this.partitioner.convertToDiskFormat(decoratedKey))) {
            return null;
        }
        Pair<String, DecoratedKey> unifiedKey = new Pair<String, DecoratedKey>(this.path, decoratedKey);
        if (this.keyCache != null && this.keyCache.getCapacity() > 0 && (cachedPosition = this.keyCache.get(unifiedKey)) != null) {
            return cachedPosition;
        }
        IndexSummary.KeyPosition sampledPosition = this.getIndexScanPosition(decoratedKey);
        if (sampledPosition == null) {
            return null;
        }
        long p = sampledPosition.indexPosition;
        if (this.indexBuffers == null) {
            input = new BufferedRandomAccessFile(this.indexFilename(), "r");
            ((BufferedRandomAccessFile)input).seek(p);
        } else {
            input = this.indexInputAt(p);
        }
        try {
            int i = 0;
            do {
                IndexSummary.KeyPosition kp;
                if ((kp = this.indexSummary.getSpannedIndexPosition(input.getAbsolutePosition())) != null && kp.key.equals(decoratedKey)) {
                    SSTable.PositionSize positionSize = this.indexSummary.getSpannedDataPosition(kp);
                    return positionSize;
                }
                if (input.isEOF() || kp != null) {
                    if (this.indexBuffers == null) {
                    } else {
                        FileDataInput oldInput = input;
                        if (kp == null) {
                            input = this.indexInputAt(input.getAbsolutePosition());
                        } else {
                            long nextUnspannedPostion = input.getAbsolutePosition() + 2L + (long)FBUtilities.encodedUTF8Length(StorageService.getPartitioner().convertToDiskFormat(kp.key)) + 8L;
                            input = this.indexInputAt(nextUnspannedPostion);
                        }
                        oldInput.close();
                        if (input != null) continue;
                    }
                    break;
                }
                DecoratedKey indexDecoratedKey = this.partitioner.convertFromDiskFormat(input.readUTF());
                long dataPosition = input.readLong();
                int v = indexDecoratedKey.compareTo(decoratedKey);
                if (v == 0) {
                    SSTable.PositionSize info = this.getDataPositionSize(input, dataPosition);
                    if (this.keyCache != null && this.keyCache.getCapacity() > 0) {
                        this.keyCache.put(unifiedKey, info);
                    }
                    SSTable.PositionSize positionSize = info;
                    return positionSize;
                }
                if (v <= 0) continue;
                SSTable.PositionSize positionSize = null;
                return positionSize;
            } while (++i < 128);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return null;
    }

    private FileDataInput indexInputAt(long indexPosition) {
        if (indexPosition > this.indexSummary.getLastIndexPosition()) {
            return null;
        }
        int bufferIndex = SSTableReader.bufferIndex(indexPosition);
        return new MappedFileDataInput(this.indexBuffers[bufferIndex], this.indexFilename(), BUFFER_SIZE * (long)bufferIndex, (int)(indexPosition % BUFFER_SIZE));
    }

    private SSTable.PositionSize getDataPositionSize(FileDataInput input, long dataPosition) throws IOException {
        if (input.isEOF()) {
            return new SSTable.PositionSize(dataPosition, this.length() - dataPosition);
        }
        long nextIndexPosition = input.getAbsolutePosition();
        SSTable.PositionSize nextPositionSize = this.indexSummary.getSpannedDataPosition(nextIndexPosition);
        if (nextPositionSize != null) {
            return new SSTable.PositionSize(dataPosition, nextPositionSize.position - dataPosition);
        }
        int utflen = input.readUnsignedShort();
        if (utflen != input.skipBytes(utflen)) {
            throw new EOFException();
        }
        return new SSTable.PositionSize(dataPosition, input.readLong() - dataPosition);
    }

    public long getNearestPosition(DecoratedKey decoratedKey) throws IOException {
        IndexSummary.KeyPosition sampledPosition = this.getIndexScanPosition(decoratedKey);
        if (sampledPosition == null) {
            return 0L;
        }
        BufferedRandomAccessFile input = new BufferedRandomAccessFile(SSTableReader.indexFilename(this.path), "r");
        input.seek(sampledPosition.indexPosition);
        try {
            while (true) {
                DecoratedKey indexDecoratedKey;
                try {
                    indexDecoratedKey = this.partitioner.convertFromDiskFormat(input.readUTF());
                }
                catch (EOFException e) {
                    long l = -1L;
                    input.close();
                    return l;
                }
                long position = input.readLong();
                int v = indexDecoratedKey.compareTo(decoratedKey);
                if (v < 0) continue;
                long l = position;
                return l;
            }
        }
        finally {
            input.close();
        }
    }

    public long length() {
        return new File(this.path).length();
    }

    @Override
    public int compareTo(SSTableReader o) {
        return ColumnFamilyStore.getGenerationFromFileName(this.path) - ColumnFamilyStore.getGenerationFromFileName(o.path);
    }

    public void markCompacted() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Marking " + this.path + " compacted"));
        }
        if (!new File(this.compactedFilename()).createNewFile()) {
            throw new IOException("Unable to create compaction marker");
        }
        this.phantomReference.deleteOnCleanup();
    }

    public void forceBloomFilterFailures() {
        this.bf = BloomFilter.alwaysMatchingBloomFilter();
    }

    public IPartitioner getPartitioner() {
        return this.partitioner;
    }

    public SSTableScanner getScanner(int bufferSize) throws IOException {
        return new SSTableScanner(this, bufferSize);
    }

    public FileDataInput getFileDataInput(DecoratedKey decoratedKey, int bufferSize) throws IOException {
        SSTable.PositionSize info = this.getPosition(decoratedKey);
        if (info == null) {
            return null;
        }
        if (this.buffers == null || SSTableReader.bufferIndex(info.position) != SSTableReader.bufferIndex(info.position + info.size)) {
            BufferedRandomAccessFile file = new BufferedRandomAccessFile(this.path, "r", bufferSize);
            file.seek(info.position);
            return file;
        }
        return new MappedFileDataInput(this.buffers[SSTableReader.bufferIndex(info.position)], this.path, BUFFER_SIZE * (info.position / BUFFER_SIZE), (int)(info.position % BUFFER_SIZE));
    }

    static int bufferIndex(long position) {
        return (int)(position / BUFFER_SIZE);
    }

    public AbstractType getColumnComparator() {
        return DatabaseDescriptor.getComparator(this.getTableName(), this.getColumnFamilyName());
    }

    public ColumnFamily makeColumnFamily() {
        return ColumnFamily.create(this.getTableName(), this.getColumnFamilyName());
    }

    public ICompactSerializer2<IColumn> getColumnSerializer() {
        return DatabaseDescriptor.getColumnFamilyType(this.getTableName(), this.getColumnFamilyName()).equals("Standard") ? Column.serializer() : SuperColumn.serializer(this.getColumnComparator());
    }
}

