/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.IteratingRow;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.log4j.Logger;

public class SSTableScanner
implements Iterator<IteratingRow>,
Closeable {
    private static Logger logger = Logger.getLogger(SSTableScanner.class);
    private final BufferedRandomAccessFile file;
    private final SSTableReader sstable;
    private IteratingRow row;
    private boolean exhausted = false;
    private Iterator<IteratingRow> iterator;

    SSTableScanner(SSTableReader sstable, int bufferSize) throws IOException {
        this.file = new BufferedRandomAccessFile(sstable.getFilename(), "r", bufferSize);
        this.sstable = sstable;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public void seekTo(DecoratedKey seekKey) {
        try {
            long position = this.sstable.getNearestPosition(seekKey);
            if (position < 0L) {
                this.exhausted = true;
                return;
            }
            this.file.seek(position);
            this.row = null;
        }
        catch (IOException e) {
            throw new RuntimeException("corrupt sstable", e);
        }
    }

    public long getFileLength() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public long getFilePointer() {
        return this.file.getFilePointer();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IteratingRow[0]).iterator() : new KeyScanningIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public IteratingRow next() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IteratingRow[0]).iterator() : new KeyScanningIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class KeyScanningIterator
    implements Iterator<IteratingRow> {
        private KeyScanningIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (SSTableScanner.this.row == null) {
                    return !SSTableScanner.this.file.isEOF();
                }
                return SSTableScanner.this.row.getEndPosition() < SSTableScanner.this.file.length();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IteratingRow next() {
            try {
                if (SSTableScanner.this.row != null) {
                    SSTableScanner.this.row.skipRemaining();
                }
                assert (!SSTableScanner.this.file.isEOF());
                return SSTableScanner.this.row = new IteratingRow(SSTableScanner.this.file, SSTableScanner.this.sstable);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

