/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.JMXInstrumentedCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.apache.log4j.Logger;

public class SSTableTracker
implements Iterable<SSTableReader> {
    private static final Logger logger = Logger.getLogger(SSTableTracker.class);
    private volatile Set<SSTableReader> sstables;
    private final AtomicLong liveSize = new AtomicLong();
    private final AtomicLong totalSize = new AtomicLong();
    private final String ksname;
    private final String cfname;
    private final JMXInstrumentedCache<Pair<String, DecoratedKey>, SSTable.PositionSize> keyCache;
    private final JMXInstrumentedCache<String, ColumnFamily> rowCache;

    public SSTableTracker(String ksname, String cfname) {
        this.ksname = ksname;
        this.cfname = cfname;
        this.sstables = Collections.emptySet();
        this.keyCache = new JMXInstrumentedCache(ksname, cfname + "KeyCache", 0);
        this.rowCache = new JMXInstrumentedCache(ksname, cfname + "RowCache", 0);
    }

    public synchronized void replace(Collection<SSTableReader> oldSSTables, Iterable<SSTableReader> replacements) throws IOException {
        HashSet<SSTableReader> sstablesNew = new HashSet<SSTableReader>(this.sstables);
        for (SSTableReader sstable : replacements) {
            assert (sstable.getIndexPositions() != null);
            sstablesNew.add(sstable);
            long size = sstable.bytesOnDisk();
            this.liveSize.addAndGet(size);
            this.totalSize.addAndGet(size);
            sstable.setTrackedBy(this);
        }
        for (SSTableReader sstable : oldSSTables) {
            boolean removed = sstablesNew.remove(sstable);
            assert (removed);
            sstable.markCompacted();
            this.liveSize.addAndGet(-sstable.bytesOnDisk());
        }
        this.sstables = Collections.unmodifiableSet(sstablesNew);
        this.updateCacheSizes();
    }

    public synchronized void add(Iterable<SSTableReader> sstables) {
        assert (sstables != null);
        try {
            this.replace(Collections.<SSTableReader>emptyList(), sstables);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public synchronized void markCompacted(Collection<SSTableReader> compacted) throws IOException {
        this.replace(compacted, Collections.<SSTableReader>emptyList());
    }

    public synchronized void updateCacheSizes() {
        int rowCacheSize;
        long keys = this.estimatedKeys();
        int keyCacheSize = DatabaseDescriptor.getKeysCachedFor(this.ksname, this.cfname, keys);
        if (keyCacheSize != this.keyCache.getCapacity()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("key cache capacity for " + this.cfname + " is " + keyCacheSize));
            }
            this.keyCache.setCapacity(keyCacheSize);
        }
        if ((rowCacheSize = DatabaseDescriptor.getRowsCachedFor(this.ksname, this.cfname, keys)) != this.rowCache.getCapacity()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("row cache capacity for " + this.cfname + " is " + rowCacheSize));
            }
            this.rowCache.setCapacity(rowCacheSize);
        }
    }

    public Set<SSTableReader> getSSTables() {
        return this.sstables;
    }

    public int size() {
        return this.sstables.size();
    }

    @Override
    public Iterator<SSTableReader> iterator() {
        return this.sstables.iterator();
    }

    public synchronized void clearUnsafe() {
        this.sstables = Collections.emptySet();
    }

    public JMXInstrumentedCache<String, ColumnFamily> getRowCache() {
        return this.rowCache;
    }

    public long estimatedKeys() {
        long n = 0L;
        for (SSTableReader sstable : this) {
            n += sstable.estimatedKeys();
        }
        return n;
    }

    public long getLiveSize() {
        return this.liveSize.get();
    }

    public long getTotalSize() {
        return this.totalSize.get();
    }

    public void spaceReclaimed(long size) {
        this.totalSize.addAndGet(-size);
    }

    public JMXInstrumentedCache<Pair<String, DecoratedKey>, SSTable.PositionSize> getKeyCache() {
        return this.keyCache;
    }
}

