/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.IndexSummary;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class SSTableWriter
extends SSTable {
    private static Logger logger = Logger.getLogger(SSTableWriter.class);
    private long keysWritten;
    private BufferedRandomAccessFile dataFile;
    private BufferedRandomAccessFile indexFile;
    private DecoratedKey lastWrittenKey;
    private BloomFilter bf;

    public SSTableWriter(String filename, long keyCount, IPartitioner partitioner) throws IOException {
        super(filename, partitioner);
        this.indexSummary = new IndexSummary();
        this.dataFile = new BufferedRandomAccessFile(this.path, "rw", (int)(DatabaseDescriptor.getFlushDataBufferSizeInMB() * 1024.0 * 1024.0));
        this.indexFile = new BufferedRandomAccessFile(this.indexFilename(), "rw", (int)(DatabaseDescriptor.getFlushIndexBufferSizeInMB() * 1024.0 * 1024.0));
        this.bf = BloomFilter.getFilter(keyCount, 15);
    }

    private long beforeAppend(DecoratedKey decoratedKey) throws IOException {
        if (decoratedKey == null) {
            throw new IOException("Keys must not be null.");
        }
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) > 0) {
            logger.info((Object)("Last written key : " + this.lastWrittenKey));
            logger.info((Object)("Current key : " + decoratedKey));
            logger.info((Object)("Writing into file " + this.path));
            throw new IOException("Keys must be written in ascending order.");
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataPosition, int dataSize) throws IOException {
        String diskKey = this.partitioner.convertToDiskFormat(decoratedKey);
        this.bf.add(diskKey);
        this.lastWrittenKey = decoratedKey;
        long indexPosition = this.indexFile.getFilePointer();
        this.indexFile.writeUTF(diskKey);
        this.indexFile.writeLong(dataPosition);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("wrote " + decoratedKey + " at " + dataPosition));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("wrote index of " + decoratedKey + " at " + indexPosition));
        }
        this.indexSummary.maybeAddEntry(decoratedKey, dataPosition, dataSize, indexPosition, this.indexFile.getFilePointer());
    }

    public void append(DecoratedKey decoratedKey, DataOutputBuffer buffer) throws IOException {
        long currentPosition = this.beforeAppend(decoratedKey);
        this.dataFile.writeUTF(this.partitioner.convertToDiskFormat(decoratedKey));
        int length = buffer.getLength();
        assert (length > 0);
        this.dataFile.writeInt(length);
        this.dataFile.write(buffer.getData(), 0, length);
        this.afterAppend(decoratedKey, currentPosition, length);
    }

    public void append(DecoratedKey decoratedKey, byte[] value) throws IOException {
        long currentPosition = this.beforeAppend(decoratedKey);
        this.dataFile.writeUTF(this.partitioner.convertToDiskFormat(decoratedKey));
        assert (value.length > 0);
        this.dataFile.writeInt(value.length);
        this.dataFile.write(value);
        this.afterAppend(decoratedKey, currentPosition, value.length);
    }

    public SSTableReader closeAndOpenReader() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.filterFilename());
        DataOutputStream stream = new DataOutputStream(fos);
        BloomFilter.serializer().serialize(this.bf, stream);
        stream.flush();
        fos.getFD().sync();
        stream.close();
        this.indexFile.getChannel().force(true);
        this.indexFile.close();
        this.dataFile.close();
        SSTableWriter.rename(this.indexFilename());
        SSTableWriter.rename(this.filterFilename());
        this.path = SSTableWriter.rename(this.path);
        this.indexSummary.complete();
        return new SSTableReader(this.path, this.partitioner, this.indexSummary, this.bf);
    }

    static String rename(String tmpFilename) {
        String filename = tmpFilename.replace("-tmp", "");
        try {
            FBUtilities.renameWithConfirm(tmpFilename, filename);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return filename;
    }

    public long getFilePointer() {
        return this.dataFile.getFilePointer();
    }

    public static SSTableReader renameAndOpen(String dataFileName) throws IOException {
        SSTableWriter.rename(SSTableWriter.indexFilename(dataFileName));
        SSTableWriter.rename(SSTableWriter.filterFilename(dataFileName));
        dataFileName = SSTableWriter.rename(dataFileName);
        return SSTableReader.open(dataFileName);
    }
}

