/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger logger_ = Logger.getLogger(FileUtils.class);
    private static final DecimalFormat df_ = new DecimalFormat("#.##");
    private static final double kb_ = 1024.0;
    private static final double mb_ = 1048576.0;
    private static final double gb_ = 1.073741824E9;
    private static final double tb_ = 1.099511627776E12;

    public static void deleteWithConfirm(File file) throws IOException {
        assert (file.exists()) : "attempted to delete non-existing file " + file.getName();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Deleting " + file.getName()));
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void createDirectory(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("unable to mkdirs " + directory);
        }
    }

    public static void createFile(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public static boolean isExists(String filename) throws IOException {
        File file = new File(filename);
        return file.exists();
    }

    public static boolean delete(String file) {
        File f = new File(file);
        return f.delete();
    }

    public static boolean delete(List<String> files) throws IOException {
        boolean bVal = true;
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i);
            bVal = FileUtils.delete(file);
            if (!bVal) continue;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Deleted file " + file));
            }
            files.remove(i);
        }
        return bVal;
    }

    public static void delete(File[] files) throws IOException {
        for (File file : files) {
            file.delete();
        }
    }

    public static String stringifyFileSize(double value) {
        double d = 0.0;
        if (value >= 1.099511627776E12) {
            d = value / 1.099511627776E12;
            String val = df_.format(d);
            return val + " TB";
        }
        if (value >= 1.073741824E9) {
            d = value / 1.073741824E9;
            String val = df_.format(d);
            return val + " GB";
        }
        if (value >= 1048576.0) {
            d = value / 1048576.0;
            String val = df_.format(d);
            return val + " MB";
        }
        if (value >= 1024.0) {
            d = value / 1024.0;
            String val = df_.format(d);
            return val + " KB";
        }
        String val = df_.format(value);
        return val + " bytes";
    }

    public static long getUsedDiskSpaceForPath(String path) {
        File file = new File(path);
        if (file.isFile()) {
            return file.length();
        }
        long diskSpace = 0L;
        for (File childFile : file.listFiles()) {
            diskSpace += FileUtils.getUsedDiskSpaceForPath(childFile.getPath());
        }
        return diskSpace;
    }

    public static void deleteDir(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.deleteDir(new File(dir, children[i]));
            }
        }
        FileUtils.deleteWithConfirm(dir);
    }

    public static void createHardLink(File sourceFile, File destinationFile) throws IOException {
        ProcessBuilder pb;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            float osversion = Float.parseFloat(System.getProperty("os.version"));
            pb = osversion >= 6.0f ? new ProcessBuilder("cmd", "/c", "mklink", "/H", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath()) : new ProcessBuilder("fsutil", "hardlink", "create", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath());
        } else {
            pb = new ProcessBuilder("ln", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
            pb.redirectErrorStream(true);
        }
        Process p = pb.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File f, File f2) {
            return (int)(f.lastModified() - f2.lastModified());
        }
    }
}

