/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import org.apache.cassandra.io.util.FileDataInput;

public class MappedFileDataInput
extends InputStream
implements FileDataInput {
    private final MappedByteBuffer buffer;
    private final String filename;
    private int position;
    private int markedPosition;
    private final long absoluteStartPosition;

    public MappedFileDataInput(MappedByteBuffer buffer, String filename, long absoluteStartPosition) {
        this(buffer, filename, absoluteStartPosition, 0);
    }

    public MappedFileDataInput(MappedByteBuffer buffer, String filename, long absoluteStartPosition, int position) {
        assert (buffer != null);
        this.absoluteStartPosition = absoluteStartPosition;
        this.buffer = buffer;
        this.filename = filename;
        this.position = position;
    }

    @Override
    public long getAbsolutePosition() {
        return this.absoluteStartPosition + (long)this.position;
    }

    private void seekInternal(int pos) throws IOException {
        this.position = pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int ignored) {
        this.markedPosition = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.seekInternal(this.markedPosition);
    }

    @Override
    public void mark() {
        this.mark(-1);
    }

    @Override
    public int bytesPastMark() {
        assert (this.position >= this.markedPosition);
        return this.position - this.markedPosition;
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.position == this.buffer.capacity();
    }

    @Override
    public String getPath() {
        return this.filename;
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        return this.buffer.get(this.position++) & 0xFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        assert (n >= 0) : "skipping negative bytes is illegal: " + n;
        if (n == 0) {
            return 0;
        }
        int oldPosition = this.position;
        assert ((long)oldPosition + (long)n <= Integer.MAX_VALUE);
        this.position = Math.min(this.buffer.capacity(), this.position + n);
        return this.position - oldPosition;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    @Override
    public final char readChar() throws IOException {
        byte[] buffer = new byte[2];
        if (this.read(buffer, 0, buffer.length) != buffer.length) {
            throw new EOFException();
        }
        return (char)(((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF));
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buffer.length || count < 0 || count > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        while (count > 0) {
            int result = this.read(buffer, offset, count);
            if (result < 0) {
                throw new EOFException();
            }
            offset += result;
            count -= result;
        }
    }

    @Override
    public final int readInt() throws IOException {
        byte[] buffer = new byte[4];
        if (this.read(buffer, 0, buffer.length) != buffer.length) {
            throw new EOFException();
        }
        return ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        int unreadPosition = 0;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seekInternal(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.position;
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seekInternal(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    @Override
    public final long readLong() throws IOException {
        byte[] buffer = new byte[8];
        int n = this.read(buffer, 0, buffer.length);
        if (n != buffer.length) {
            throw new EOFException("expected 8 bytes; read " + n + " at final position " + this.position);
        }
        return ((long)(((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF)) << 32) + ((long)(buffer[4] & 0xFF) << 24) + (long)((buffer[5] & 0xFF) << 16) + (long)((buffer[6] & 0xFF) << 8) + (long)(buffer[7] & 0xFF);
    }

    @Override
    public final short readShort() throws IOException {
        byte[] buffer = new byte[2];
        if (this.read(buffer, 0, buffer.length) != buffer.length) {
            throw new EOFException();
        }
        return (short)(((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF));
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int temp = this.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        byte[] buffer = new byte[2];
        if (this.read(buffer, 0, buffer.length) != buffer.length) {
            throw new EOFException();
        }
        return ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

