/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.locator.IEndPointSnitch;

public abstract class AbstractEndpointSnitch
implements IEndPointSnitch {
    public abstract boolean isOnSameRack(InetAddress var1, InetAddress var2) throws UnknownHostException;

    public abstract boolean isInSameDataCenter(InetAddress var1, InetAddress var2) throws UnknownHostException;

    public abstract String getLocation(InetAddress var1) throws UnknownHostException;

    @Override
    public List<InetAddress> getSortedListByProximity(InetAddress address, Collection<InetAddress> unsortedAddress) {
        ArrayList<InetAddress> preferred = new ArrayList<InetAddress>(unsortedAddress);
        this.sortByProximity(address, preferred);
        return preferred;
    }

    @Override
    public List<InetAddress> sortByProximity(final InetAddress address, List<InetAddress> addresses) {
        Collections.sort(addresses, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress a1, InetAddress a2) {
                try {
                    if (address.equals(a1) && !address.equals(a2)) {
                        return -1;
                    }
                    if (address.equals(a2) && !address.equals(a1)) {
                        return 1;
                    }
                    if (AbstractEndpointSnitch.this.isOnSameRack(address, a1) && !AbstractEndpointSnitch.this.isOnSameRack(address, a2)) {
                        return -1;
                    }
                    if (AbstractEndpointSnitch.this.isOnSameRack(address, a2) && !AbstractEndpointSnitch.this.isOnSameRack(address, a1)) {
                        return 1;
                    }
                    if (AbstractEndpointSnitch.this.isInSameDataCenter(address, a1) && !AbstractEndpointSnitch.this.isInSameDataCenter(address, a2)) {
                        return -1;
                    }
                    if (AbstractEndpointSnitch.this.isInSameDataCenter(address, a2) && !AbstractEndpointSnitch.this.isInSameDataCenter(address, a1)) {
                        return 1;
                    }
                    return 0;
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return addresses;
    }
}

